package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import java.lang.SuppressWarnings;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSigningRequestSpecFluentImpl<A extends CertificateSigningRequestSpecFluent<A>> extends BaseFluent<A> implements CertificateSigningRequestSpecFluent<A>{
  public CertificateSigningRequestSpecFluentImpl() {
  }
  public CertificateSigningRequestSpecFluentImpl(CertificateSigningRequestSpec instance) {
    if (instance != null) {
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withExtra(instance.getExtra());
      this.withGroups(instance.getGroups());
      this.withRequest(instance.getRequest());
      this.withSignerName(instance.getSignerName());
      this.withUid(instance.getUid());
      this.withUsages(instance.getUsages());
      this.withUsername(instance.getUsername());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Integer expirationSeconds;
  private Map<String,ArrayList<String>> extra;
  private List<String> groups = new ArrayList<String>();
  private String request;
  private String signerName;
  private String uid;
  private List<String> usages = new ArrayList<String>();
  private String username;
  private Map<String,Object> additionalProperties;
  public Integer getExpirationSeconds() {
    return this.expirationSeconds;
  }
  public A withExpirationSeconds(Integer expirationSeconds) {
    this.expirationSeconds=expirationSeconds; return (A) this;
  }
  public Boolean hasExpirationSeconds() {
    return this.expirationSeconds != null;
  }
  public A addToExtra(String key,ArrayList<String> value) {
    if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap(); }
    if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
  }
  public A addToExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null && map != null) { this.extra = new LinkedHashMap(); }
    if(map != null) { this.extra.putAll(map);} return (A)this;
  }
  public A removeFromExtra(String key) {
    if(this.extra == null) { return (A) this; }
    if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
  }
  public A removeFromExtra(Map<String,ArrayList<String>> map) {
    if(this.extra == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
  }
  public Map<String,ArrayList<String>> getExtra() {
    return this.extra;
  }
  public <K,V>A withExtra(Map<String,ArrayList<String>> extra) {
    if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap(extra);} return (A) this;
  }
  public Boolean hasExtra() {
    return this.extra != null;
  }
  public A addToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.add(index, item);
    return (A)this;
  }
  public A setToGroups(int index,String item) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    this.groups.set(index, item); return (A)this;
  }
  public A addToGroups(java.lang.String... items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A addAllToGroups(Collection<String> items) {
    if (this.groups == null) {this.groups = new ArrayList<String>();}
    for (String item : items) {this.groups.add(item);} return (A)this;
  }
  public A removeFromGroups(java.lang.String... items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public A removeAllFromGroups(Collection<String> items) {
    for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
  }
  public List<String> getGroups() {
    return this.groups;
  }
  public String getGroup(int index) {
    return this.groups.get(index);
  }
  public String getFirstGroup() {
    return this.groups.get(0);
  }
  public String getLastGroup() {
    return this.groups.get(groups.size() - 1);
  }
  public String getMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingGroup(Predicate<String> predicate) {
    for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withGroups(List<String> groups) {
    if (groups != null) {this.groups = new ArrayList(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
  }
  public A withGroups(java.lang.String... groups) {
    if (this.groups != null) {this.groups.clear(); _visitables.remove("groups"); }
    if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
  }
  public Boolean hasGroups() {
    return groups != null && !groups.isEmpty();
  }
  public String getRequest() {
    return this.request;
  }
  public A withRequest(String request) {
    this.request=request; return (A) this;
  }
  public Boolean hasRequest() {
    return this.request != null;
  }
  public String getSignerName() {
    return this.signerName;
  }
  public A withSignerName(String signerName) {
    this.signerName=signerName; return (A) this;
  }
  public Boolean hasSignerName() {
    return this.signerName != null;
  }
  public String getUid() {
    return this.uid;
  }
  public A withUid(String uid) {
    this.uid=uid; return (A) this;
  }
  public Boolean hasUid() {
    return this.uid != null;
  }
  public A addToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.add(index, item);
    return (A)this;
  }
  public A setToUsages(int index,String item) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    this.usages.set(index, item); return (A)this;
  }
  public A addToUsages(java.lang.String... items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A addAllToUsages(Collection<String> items) {
    if (this.usages == null) {this.usages = new ArrayList<String>();}
    for (String item : items) {this.usages.add(item);} return (A)this;
  }
  public A removeFromUsages(java.lang.String... items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public A removeAllFromUsages(Collection<String> items) {
    for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
  }
  public List<String> getUsages() {
    return this.usages;
  }
  public String getUsage(int index) {
    return this.usages.get(index);
  }
  public String getFirstUsage() {
    return this.usages.get(0);
  }
  public String getLastUsage() {
    return this.usages.get(usages.size() - 1);
  }
  public String getMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingUsage(Predicate<String> predicate) {
    for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withUsages(List<String> usages) {
    if (usages != null) {this.usages = new ArrayList(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
  }
  public A withUsages(java.lang.String... usages) {
    if (this.usages != null) {this.usages.clear(); _visitables.remove("usages"); }
    if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
  }
  public Boolean hasUsages() {
    return usages != null && !usages.isEmpty();
  }
  public String getUsername() {
    return this.username;
  }
  public A withUsername(String username) {
    this.username=username; return (A) this;
  }
  public Boolean hasUsername() {
    return this.username != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateSigningRequestSpecFluentImpl that = (CertificateSigningRequestSpecFluentImpl) o;
    if (!java.util.Objects.equals(expirationSeconds, that.expirationSeconds)) return false;

    if (!java.util.Objects.equals(extra, that.extra)) return false;

    if (!java.util.Objects.equals(groups, that.groups)) return false;

    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(signerName, that.signerName)) return false;

    if (!java.util.Objects.equals(uid, that.uid)) return false;

    if (!java.util.Objects.equals(usages, that.usages)) return false;

    if (!java.util.Objects.equals(username, that.username)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(expirationSeconds,  extra,  groups,  request,  signerName,  uid,  usages,  username,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (expirationSeconds != null) { sb.append("expirationSeconds:"); sb.append(expirationSeconds + ","); }
    if (extra != null && !extra.isEmpty()) { sb.append("extra:"); sb.append(extra + ","); }
    if (groups != null && !groups.isEmpty()) { sb.append("groups:"); sb.append(groups + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (signerName != null) { sb.append("signerName:"); sb.append(signerName + ","); }
    if (uid != null) { sb.append("uid:"); sb.append(uid + ","); }
    if (usages != null && !usages.isEmpty()) { sb.append("usages:"); sb.append(usages + ","); }
    if (username != null) { sb.append("username:"); sb.append(username + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}