package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CertificateSigningRequestStatusFluentImpl<A extends CertificateSigningRequestStatusFluent<A>> extends BaseFluent<A> implements CertificateSigningRequestStatusFluent<A>{
  public CertificateSigningRequestStatusFluentImpl() {
  }
  public CertificateSigningRequestStatusFluentImpl(CertificateSigningRequestStatus instance) {
    if (instance != null) {
      this.withCertificate(instance.getCertificate());
      this.withConditions(instance.getConditions());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String certificate;
  private ArrayList<CertificateSigningRequestConditionBuilder> conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();
  private Map<String,Object> additionalProperties;
  public String getCertificate() {
    return this.certificate;
  }
  public A withCertificate(String certificate) {
    this.certificate=certificate; return (A) this;
  }
  public Boolean hasCertificate() {
    return this.certificate != null;
  }
  public A addToConditions(int index,CertificateSigningRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();}
    CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  public A setToConditions(int index,CertificateSigningRequestCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();}
    CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();}
    for (CertificateSigningRequestCondition item : items) {CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<CertificateSigningRequestCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<CertificateSigningRequestConditionBuilder>();}
    for (CertificateSigningRequestCondition item : items) {CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition... items) {
    for (CertificateSigningRequestCondition item : items) {CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<CertificateSigningRequestCondition> items) {
    for (CertificateSigningRequestCondition item : items) {CertificateSigningRequestConditionBuilder builder = new CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<CertificateSigningRequestConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      CertificateSigningRequestConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CertificateSigningRequestCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public List<CertificateSigningRequestCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public CertificateSigningRequestCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  public CertificateSigningRequestCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public CertificateSigningRequestCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public CertificateSigningRequestCondition buildMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
    for (CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
    for (CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<CertificateSigningRequestCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").clear();}
    if (conditions != null) {this.conditions = new ArrayList(); for (CertificateSigningRequestCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (CertificateSigningRequestCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> addNewCondition() {
    return new CertificateSigningRequestStatusFluentImpl.ConditionsNestedImpl();
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> addNewConditionLike(CertificateSigningRequestCondition item) {
    return new CertificateSigningRequestStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> setNewConditionLike(int index,CertificateSigningRequestCondition item) {
    return new CertificateSigningRequestStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public CertificateSigningRequestStatusFluentImpl.ConditionsNested<A> editMatchingCondition(Predicate<CertificateSigningRequestConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CertificateSigningRequestStatusFluentImpl that = (CertificateSigningRequestStatusFluentImpl) o;
    if (!java.util.Objects.equals(certificate, that.certificate)) return false;

    if (!java.util.Objects.equals(conditions, that.conditions)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(certificate,  conditions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (certificate != null) { sb.append("certificate:"); sb.append(certificate + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends CertificateSigningRequestConditionFluentImpl<CertificateSigningRequestStatusFluentImpl.ConditionsNested<N>> implements CertificateSigningRequestStatusFluentImpl.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(int index,CertificateSigningRequestCondition item) {
      this.index = index;
      this.builder = new CertificateSigningRequestConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new CertificateSigningRequestConditionBuilder(this);
    }
    CertificateSigningRequestConditionBuilder builder;
    int index;
    public N and() {
      return (N) CertificateSigningRequestStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}