package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSigningRequestListBuilder extends CertificateSigningRequestListFluentImpl<CertificateSigningRequestListBuilder> implements VisitableBuilder<CertificateSigningRequestList,CertificateSigningRequestListBuilder>{
  public CertificateSigningRequestListBuilder() {
    this(false);
  }
  public CertificateSigningRequestListBuilder(Boolean validationEnabled) {
    this(new CertificateSigningRequestList(), validationEnabled);
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestListFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestList(), validationEnabled);
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestListFluent<?> fluent,CertificateSigningRequestList instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestListFluent<?> fluent,CertificateSigningRequestList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestList instance) {
    this(instance,false);
  }
  public CertificateSigningRequestListBuilder(CertificateSigningRequestList instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CertificateSigningRequestListFluent<?> fluent;
  Boolean validationEnabled;
  public CertificateSigningRequestList build() {
    CertificateSigningRequestList buildable = new CertificateSigningRequestList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}