package io.fabric8.kubernetes.api.model.certificates.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CertificateSigningRequestSpecBuilder extends CertificateSigningRequestSpecFluentImpl<CertificateSigningRequestSpecBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecBuilder>{
  public CertificateSigningRequestSpecBuilder() {
    this(false);
  }
  public CertificateSigningRequestSpecBuilder(Boolean validationEnabled) {
    this(new CertificateSigningRequestSpec(), validationEnabled);
  }
  public CertificateSigningRequestSpecBuilder(CertificateSigningRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public CertificateSigningRequestSpecBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CertificateSigningRequestSpec(), validationEnabled);
  }
  public CertificateSigningRequestSpecBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec instance) {
    this(fluent, instance, false);
  }
  public CertificateSigningRequestSpecBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExpirationSeconds(instance.getExpirationSeconds()); 
    fluent.withExtra(instance.getExtra()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withRequest(instance.getRequest()); 
    fluent.withSignerName(instance.getSignerName()); 
    fluent.withUid(instance.getUid()); 
    fluent.withUsages(instance.getUsages()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CertificateSigningRequestSpecBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec instance) {
    this(instance,false);
  }
  public CertificateSigningRequestSpecBuilder(io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withExpirationSeconds(instance.getExpirationSeconds()); 
    this.withExtra(instance.getExtra()); 
    this.withGroups(instance.getGroups()); 
    this.withRequest(instance.getRequest()); 
    this.withSignerName(instance.getSignerName()); 
    this.withUid(instance.getUid()); 
    this.withUsages(instance.getUsages()); 
    this.withUsername(instance.getUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.certificates.v1.CertificateSigningRequestSpec build() {
    CertificateSigningRequestSpec buildable = new CertificateSigningRequestSpec(fluent.getExpirationSeconds(),fluent.getExtra(),fluent.getGroups(),fluent.getRequest(),fluent.getSignerName(),fluent.getUid(),fluent.getUsages(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}