package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateSigningRequestListBuilder extends io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluentImpl<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListBuilder> {

    io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluent<?> fluent;
    Boolean validationEnabled;

    public CertificateSigningRequestListBuilder() {
        this(true);
    }

    public CertificateSigningRequestListBuilder(Boolean validationEnabled) {
        this(new CertificateSigningRequestList(), validationEnabled);
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluent<?> fluent) {
        this(fluent, true);
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CertificateSigningRequestList(), validationEnabled);
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList instance) {
        this(fluent, instance, true);
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestListFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withItems(instance.getItems()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList instance) {
        this(instance,true);
    }

    public CertificateSigningRequestListBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withItems(instance.getItems()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestList build() {
        CertificateSigningRequestList buildable = new CertificateSigningRequestList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertificateSigningRequestListBuilder that = (CertificateSigningRequestListBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
