package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CertificateSigningRequestConditionBuilder extends io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluentImpl<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> {

    io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluent<?> fluent;
    Boolean validationEnabled;

    public CertificateSigningRequestConditionBuilder() {
        this(true);
    }

    public CertificateSigningRequestConditionBuilder(Boolean validationEnabled) {
        this(new CertificateSigningRequestCondition(), validationEnabled);
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluent<?> fluent) {
        this(fluent, true);
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CertificateSigningRequestCondition(), validationEnabled);
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition instance) {
        this(fluent, instance, true);
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
        fluent.withLastUpdateTime(instance.getLastUpdateTime()); 
        fluent.withMessage(instance.getMessage()); 
        fluent.withReason(instance.getReason()); 
        fluent.withStatus(instance.getStatus()); 
        fluent.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition instance) {
        this(instance,true);
    }

    public CertificateSigningRequestConditionBuilder(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withLastTransitionTime(instance.getLastTransitionTime()); 
        this.withLastUpdateTime(instance.getLastUpdateTime()); 
        this.withMessage(instance.getMessage()); 
        this.withReason(instance.getReason()); 
        this.withStatus(instance.getStatus()); 
        this.withType(instance.getType()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition build() {
        CertificateSigningRequestCondition buildable = new CertificateSigningRequestCondition(fluent.getLastTransitionTime(),fluent.getLastUpdateTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CertificateSigningRequestConditionBuilder that = (CertificateSigningRequestConditionBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
