package io.fabric8.kubernetes.api.model.certificates.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

public class CertificateSigningRequestStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent<A> {

    private String certificate;
    private List<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> conditions =  new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>();

    public CertificateSigningRequestStatusFluentImpl() {
    }

    public CertificateSigningRequestStatusFluentImpl(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatus instance) {
        this.withCertificate(instance.getCertificate()); 
        this.withConditions(instance.getConditions()); 
    }

    public String getCertificate() {
        return this.certificate;
    }

    public A withCertificate(String certificate) {
        this.certificate=certificate; return (A) this;
    }

    public Boolean hasCertificate() {
        return this.certificate != null;
    }

    public A withNewCertificate(StringBuilder arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(int[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(char[] arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(StringBuffer arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(byte[] arg1,int arg2) {
        return (A)withCertificate(new String(arg1, arg2));
    }

    public A withNewCertificate(byte[] arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A withNewCertificate(char[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(byte[] arg1,int arg2,int arg3) {
        return (A)withCertificate(new String(arg1, arg2, arg3));
    }

    public A withNewCertificate(byte[] arg1,int arg2,int arg3,int arg4) {
        return (A)withCertificate(new String(arg1, arg2, arg3, arg4));
    }

    public A withNewCertificate(String arg1) {
        return (A)withCertificate(new String(arg1));
    }

    public A addToConditions(int index,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>();}
        io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
    }

    public A setToConditions(int index,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>();}
        io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);
        if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
        if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
         return (A)this;
    }

    public A addToConditions(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition... items) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item : items) {io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition> items) {
        if (this.conditions == null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>();}
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item : items) {io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
    }

    public A removeFromConditions(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition... items) {
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item : items) {io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeAllFromConditions(Collection<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition> items) {
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item : items) {io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> predicate) {
        if (conditions == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> each = conditions.iterator();
        final List visitables = _visitables.get("conditions");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
/**
 * This method has been deprecated, please use method buildConditions instead.
 * @return The buildable object.
 */
@Deprecated public List<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition> getConditions() {
        return build(conditions);
    }

    public List<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition> buildConditions() {
        return build(conditions);
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition buildCondition(int index) {
        return this.conditions.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition buildFirstCondition() {
        return this.conditions.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition buildLastCondition() {
        return this.conditions.get(conditions.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition buildMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public Boolean hasMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withConditions(List<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition> conditions) {
        if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
        if (conditions != null) {this.conditions = new ArrayList<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder>(); for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
    }

    public A withConditions(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition... conditions) {
        if (this.conditions != null) {this.conditions.clear();}
        if (conditions != null) {for (io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item :conditions){ this.addToConditions(item);}} return (A) this;
    }

    public Boolean hasConditions() {
        return conditions != null && !conditions.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> setNewConditionLike(int index,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item) {
        return new ConditionsNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> editCondition(int index) {
        if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> editFirstCondition() {
        if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
        return setNewConditionLike(0, buildCondition(0));
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> editLastCondition() {
        int index = conditions.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder> predicate) {
        int index = -1;
        for (int i=0;i<conditions.size();i++) { 
        if (predicate.test(conditions.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
        return setNewConditionLike(index, buildCondition(index));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertificateSigningRequestStatusFluentImpl that = (CertificateSigningRequestStatusFluentImpl) o;
        if (certificate != null ? !certificate.equals(that.certificate) :that.certificate != null) return false;
        if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(certificate,  conditions,  super.hashCode());
    }

    public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionFluentImpl<io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder builder;
        private final int index;

            ConditionsNestedImpl(int index,io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestCondition item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(this, item);
                        
            }

            ConditionsNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.certificates.v1beta1.CertificateSigningRequestConditionBuilder(this);
                        
            }

            public N and() {
                return (N) CertificateSigningRequestStatusFluentImpl.this.setToConditions(index,builder.build());
            }

            public N endCondition() {
                return and();
            }
    }


}
