package io.fabric8.kubernetes.api.model.certificates;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.StringBuffer;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

public class CertificateSigningRequestSpecFluentImpl<A extends CertificateSigningRequestSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements CertificateSigningRequestSpecFluent<A> {

    private Map<String,ArrayList<String>> extra;
    private List<String> groups = new ArrayList<String>();
    private String request;
    private String signerName;
    private String uid;
    private List<String> usages = new ArrayList<String>();
    private String username;

    public CertificateSigningRequestSpecFluentImpl() {
    }

    public CertificateSigningRequestSpecFluentImpl(CertificateSigningRequestSpec instance) {
        this.withExtra(instance.getExtra()); 
        this.withGroups(instance.getGroups()); 
        this.withRequest(instance.getRequest()); 
        this.withSignerName(instance.getSignerName()); 
        this.withUid(instance.getUid()); 
        this.withUsages(instance.getUsages()); 
        this.withUsername(instance.getUsername()); 
    }

    public A addToExtra(String key,ArrayList<String> value) {
        if(this.extra == null && key != null && value != null) { this.extra = new LinkedHashMap<String,ArrayList<String>>(); }
        if(key != null && value != null) {this.extra.put(key, value);} return (A)this;
    }

    public A addToExtra(Map<String,ArrayList<String>> map) {
        if(this.extra == null && map != null) { this.extra = new LinkedHashMap<String,ArrayList<String>>(); }
        if(map != null) { this.extra.putAll(map);} return (A)this;
    }

    public A removeFromExtra(String key) {
        if(this.extra == null) { return (A) this; }
        if(key != null && this.extra != null) {this.extra.remove(key);} return (A)this;
    }

    public A removeFromExtra(Map<String,ArrayList<String>> map) {
        if(this.extra == null) { return (A) this; }
        if(map != null) { for(Object key : map.keySet()) {if (this.extra != null){this.extra.remove(key);}}} return (A)this;
    }

    public Map<String,ArrayList<String>> getExtra() {
        return this.extra;
    }

    public A withExtra(Map<String,ArrayList<String>> extra) {
        if (extra == null) { this.extra =  null;} else {this.extra = new LinkedHashMap<String,ArrayList<String>>(extra);} return (A) this;
    }

    public Boolean hasExtra() {
        return this.extra != null;
    }

    public A addToGroups(int index,String item) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        this.groups.add(index, item);
        return (A)this;
    }

    public A setToGroups(int index,String item) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        this.groups.set(index, item); return (A)this;
    }

    public A addToGroups(String... items) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A addAllToGroups(Collection<String> items) {
        if (this.groups == null) {this.groups = new ArrayList<String>();}
        for (String item : items) {this.groups.add(item);} return (A)this;
    }

    public A removeFromGroups(String... items) {
        for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public A removeAllFromGroups(Collection<String> items) {
        for (String item : items) {if (this.groups!= null){ this.groups.remove(item);}} return (A)this;
    }

    public List<String> getGroups() {
        return this.groups;
    }

    public String getGroup(int index) {
        return this.groups.get(index);
    }

    public String getFirstGroup() {
        return this.groups.get(0);
    }

    public String getLastGroup() {
        return this.groups.get(groups.size() - 1);
    }

    public String getMatchingGroup(Predicate<String> predicate) {
        for (String item: groups) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingGroup(Predicate<String> predicate) {
        for (String item: groups) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withGroups(List<String> groups) {
        if (this.groups != null) { _visitables.get("groups").removeAll(this.groups);}
        if (groups != null) {this.groups = new ArrayList<String>(); for (String item : groups){this.addToGroups(item);}} else { this.groups = null;} return (A) this;
    }

    public A withGroups(String... groups) {
        if (this.groups != null) {this.groups.clear();}
        if (groups != null) {for (String item :groups){ this.addToGroups(item);}} return (A) this;
    }

    public Boolean hasGroups() {
        return groups != null && !groups.isEmpty();
    }

    public A addNewGroup(String arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuilder arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public A addNewGroup(StringBuffer arg1) {
        return (A)addToGroups(new String(arg1));
    }

    public String getRequest() {
        return this.request;
    }

    public A withRequest(String request) {
        this.request=request; return (A) this;
    }

    public Boolean hasRequest() {
        return this.request != null;
    }

    public A withNewRequest(String arg1) {
        return (A)withRequest(new String(arg1));
    }

    public A withNewRequest(StringBuilder arg1) {
        return (A)withRequest(new String(arg1));
    }

    public A withNewRequest(StringBuffer arg1) {
        return (A)withRequest(new String(arg1));
    }

    public String getSignerName() {
        return this.signerName;
    }

    public A withSignerName(String signerName) {
        this.signerName=signerName; return (A) this;
    }

    public Boolean hasSignerName() {
        return this.signerName != null;
    }

    public A withNewSignerName(String arg1) {
        return (A)withSignerName(new String(arg1));
    }

    public A withNewSignerName(StringBuilder arg1) {
        return (A)withSignerName(new String(arg1));
    }

    public A withNewSignerName(StringBuffer arg1) {
        return (A)withSignerName(new String(arg1));
    }

    public String getUid() {
        return this.uid;
    }

    public A withUid(String uid) {
        this.uid=uid; return (A) this;
    }

    public Boolean hasUid() {
        return this.uid != null;
    }

    public A withNewUid(String arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuilder arg1) {
        return (A)withUid(new String(arg1));
    }

    public A withNewUid(StringBuffer arg1) {
        return (A)withUid(new String(arg1));
    }

    public A addToUsages(int index,String item) {
        if (this.usages == null) {this.usages = new ArrayList<String>();}
        this.usages.add(index, item);
        return (A)this;
    }

    public A setToUsages(int index,String item) {
        if (this.usages == null) {this.usages = new ArrayList<String>();}
        this.usages.set(index, item); return (A)this;
    }

    public A addToUsages(String... items) {
        if (this.usages == null) {this.usages = new ArrayList<String>();}
        for (String item : items) {this.usages.add(item);} return (A)this;
    }

    public A addAllToUsages(Collection<String> items) {
        if (this.usages == null) {this.usages = new ArrayList<String>();}
        for (String item : items) {this.usages.add(item);} return (A)this;
    }

    public A removeFromUsages(String... items) {
        for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public A removeAllFromUsages(Collection<String> items) {
        for (String item : items) {if (this.usages!= null){ this.usages.remove(item);}} return (A)this;
    }

    public List<String> getUsages() {
        return this.usages;
    }

    public String getUsage(int index) {
        return this.usages.get(index);
    }

    public String getFirstUsage() {
        return this.usages.get(0);
    }

    public String getLastUsage() {
        return this.usages.get(usages.size() - 1);
    }

    public String getMatchingUsage(Predicate<String> predicate) {
        for (String item: usages) { if(predicate.test(item)){ return item;} } return null;
    }

    public Boolean hasMatchingUsage(Predicate<String> predicate) {
        for (String item: usages) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withUsages(List<String> usages) {
        if (this.usages != null) { _visitables.get("usages").removeAll(this.usages);}
        if (usages != null) {this.usages = new ArrayList<String>(); for (String item : usages){this.addToUsages(item);}} else { this.usages = null;} return (A) this;
    }

    public A withUsages(String... usages) {
        if (this.usages != null) {this.usages.clear();}
        if (usages != null) {for (String item :usages){ this.addToUsages(item);}} return (A) this;
    }

    public Boolean hasUsages() {
        return usages != null && !usages.isEmpty();
    }

    public A addNewUsage(String arg1) {
        return (A)addToUsages(new String(arg1));
    }

    public A addNewUsage(StringBuilder arg1) {
        return (A)addToUsages(new String(arg1));
    }

    public A addNewUsage(StringBuffer arg1) {
        return (A)addToUsages(new String(arg1));
    }

    public String getUsername() {
        return this.username;
    }

    public A withUsername(String username) {
        this.username=username; return (A) this;
    }

    public Boolean hasUsername() {
        return this.username != null;
    }

    public A withNewUsername(String arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuilder arg1) {
        return (A)withUsername(new String(arg1));
    }

    public A withNewUsername(StringBuffer arg1) {
        return (A)withUsername(new String(arg1));
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        CertificateSigningRequestSpecFluentImpl that = (CertificateSigningRequestSpecFluentImpl) o;
        if (extra != null ? !extra.equals(that.extra) :that.extra != null) return false;
        if (groups != null ? !groups.equals(that.groups) :that.groups != null) return false;
        if (request != null ? !request.equals(that.request) :that.request != null) return false;
        if (signerName != null ? !signerName.equals(that.signerName) :that.signerName != null) return false;
        if (uid != null ? !uid.equals(that.uid) :that.uid != null) return false;
        if (usages != null ? !usages.equals(that.usages) :that.usages != null) return false;
        if (username != null ? !username.equals(that.username) :that.username != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(extra,  groups,  request,  signerName,  uid,  usages,  username,  super.hashCode());
    }

}
