package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobStatusFluent<A extends JobStatusFluent<A>> extends BaseFluent<A>{
  public JobStatusFluent() {
  }
  
  public JobStatusFluent(JobStatus instance) {
    this.copyInstance(instance);
  }
  private Integer active;
  private String completedIndexes;
  private String completionTime;
  private ArrayList<JobConditionBuilder> conditions = new ArrayList<JobConditionBuilder>();
  private Integer failed;
  private String failedIndexes;
  private Integer ready;
  private String startTime;
  private Integer succeeded;
  private Integer terminating;
  private UncountedTerminatedPodsBuilder uncountedTerminatedPods;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JobStatus instance) {
    instance = (instance != null ? instance : new JobStatus());
    if (instance != null) {
          this.withActive(instance.getActive());
          this.withCompletedIndexes(instance.getCompletedIndexes());
          this.withCompletionTime(instance.getCompletionTime());
          this.withConditions(instance.getConditions());
          this.withFailed(instance.getFailed());
          this.withFailedIndexes(instance.getFailedIndexes());
          this.withReady(instance.getReady());
          this.withStartTime(instance.getStartTime());
          this.withSucceeded(instance.getSucceeded());
          this.withTerminating(instance.getTerminating());
          this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
          this.withActive(instance.getActive());
          this.withCompletedIndexes(instance.getCompletedIndexes());
          this.withCompletionTime(instance.getCompletionTime());
          this.withConditions(instance.getConditions());
          this.withFailed(instance.getFailed());
          this.withFailedIndexes(instance.getFailedIndexes());
          this.withReady(instance.getReady());
          this.withStartTime(instance.getStartTime());
          this.withSucceeded(instance.getSucceeded());
          this.withTerminating(instance.getTerminating());
          this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Integer getActive() {
    return this.active;
  }
  
  public A withActive(Integer active) {
    this.active = active;
    return (A) this;
  }
  
  public boolean hasActive() {
    return this.active != null;
  }
  
  public String getCompletedIndexes() {
    return this.completedIndexes;
  }
  
  public A withCompletedIndexes(String completedIndexes) {
    this.completedIndexes = completedIndexes;
    return (A) this;
  }
  
  public boolean hasCompletedIndexes() {
    return this.completedIndexes != null;
  }
  
  public String getCompletionTime() {
    return this.completionTime;
  }
  
  public A withCompletionTime(String completionTime) {
    this.completionTime = completionTime;
    return (A) this;
  }
  
  public boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  
  public A addToConditions(int index,JobCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<JobConditionBuilder>();}
    JobConditionBuilder builder = new JobConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").add(index, builder); conditions.add(index, builder);}
    return (A)this;
  }
  
  public A setToConditions(int index,JobCondition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<JobConditionBuilder>();}
    JobConditionBuilder builder = new JobConditionBuilder(item);
    if (index < 0 || index >= conditions.size()) { _visitables.get("conditions").add(builder); conditions.add(builder); } else { _visitables.get("conditions").set(index, builder); conditions.set(index, builder);}
    return (A)this;
  }
  
  public A addToConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<JobConditionBuilder>();}
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A addAllToConditions(Collection<JobCondition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<JobConditionBuilder>();}
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  
  public A removeFromConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    if (this.conditions == null) return (A)this;
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromConditions(Collection<JobCondition> items) {
    if (this.conditions == null) return (A)this;
    for (JobCondition item : items) {JobConditionBuilder builder = new JobConditionBuilder(item);_visitables.get("conditions").remove(builder); this.conditions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<JobConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      JobConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<JobCondition> buildConditions() {
    return this.conditions != null ? build(conditions) : null;
  }
  
  public JobCondition buildCondition(int index) {
    return this.conditions.get(index).build();
  }
  
  public JobCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  
  public JobCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  
  public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate) {
      for (JobConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate) {
      for (JobConditionBuilder item : conditions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withConditions(List<JobCondition> conditions) {
    if (this.conditions != null) {
      this._visitables.get("conditions").clear();
    }
    if (conditions != null) {
        this.conditions = new ArrayList();
        for (JobCondition item : conditions) {
          this.addToConditions(item);
        }
    } else {
      this.conditions = null;
    }
    return (A) this;
  }
  
  public A withConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear(); _visitables.remove("conditions"); }
    if (conditions != null) {for (JobCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  
  public boolean hasConditions() {
    return this.conditions != null && !this.conditions.isEmpty();
  }
  
  public ConditionsNested<A> addNewCondition() {
    return new ConditionsNested(-1, null);
  }
  
  public ConditionsNested<A> addNewConditionLike(JobCondition item) {
    return new ConditionsNested(-1, item);
  }
  
  public ConditionsNested<A> setNewConditionLike(int index,JobCondition item) {
    return new ConditionsNested(index, item);
  }
  
  public ConditionsNested<A> editCondition(int index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  
  public ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  
  public Integer getFailed() {
    return this.failed;
  }
  
  public A withFailed(Integer failed) {
    this.failed = failed;
    return (A) this;
  }
  
  public boolean hasFailed() {
    return this.failed != null;
  }
  
  public String getFailedIndexes() {
    return this.failedIndexes;
  }
  
  public A withFailedIndexes(String failedIndexes) {
    this.failedIndexes = failedIndexes;
    return (A) this;
  }
  
  public boolean hasFailedIndexes() {
    return this.failedIndexes != null;
  }
  
  public Integer getReady() {
    return this.ready;
  }
  
  public A withReady(Integer ready) {
    this.ready = ready;
    return (A) this;
  }
  
  public boolean hasReady() {
    return this.ready != null;
  }
  
  public String getStartTime() {
    return this.startTime;
  }
  
  public A withStartTime(String startTime) {
    this.startTime = startTime;
    return (A) this;
  }
  
  public boolean hasStartTime() {
    return this.startTime != null;
  }
  
  public Integer getSucceeded() {
    return this.succeeded;
  }
  
  public A withSucceeded(Integer succeeded) {
    this.succeeded = succeeded;
    return (A) this;
  }
  
  public boolean hasSucceeded() {
    return this.succeeded != null;
  }
  
  public Integer getTerminating() {
    return this.terminating;
  }
  
  public A withTerminating(Integer terminating) {
    this.terminating = terminating;
    return (A) this;
  }
  
  public boolean hasTerminating() {
    return this.terminating != null;
  }
  
  public UncountedTerminatedPods buildUncountedTerminatedPods() {
    return this.uncountedTerminatedPods != null ? this.uncountedTerminatedPods.build() : null;
  }
  
  public A withUncountedTerminatedPods(UncountedTerminatedPods uncountedTerminatedPods) {
    this._visitables.remove(this.uncountedTerminatedPods);
    if (uncountedTerminatedPods != null) {
        this.uncountedTerminatedPods = new UncountedTerminatedPodsBuilder(uncountedTerminatedPods);
        this._visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);
    } else {
        this.uncountedTerminatedPods = null;
        this._visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
    }
    return (A) this;
  }
  
  public boolean hasUncountedTerminatedPods() {
    return this.uncountedTerminatedPods != null;
  }
  
  public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
    return new UncountedTerminatedPodsNested(null);
  }
  
  public UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
    return new UncountedTerminatedPodsNested(item);
  }
  
  public UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
    return withNewUncountedTerminatedPodsLike(java.util.Optional.ofNullable(buildUncountedTerminatedPods()).orElse(null));
  }
  
  public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
    return withNewUncountedTerminatedPodsLike(java.util.Optional.ofNullable(buildUncountedTerminatedPods()).orElse(new UncountedTerminatedPodsBuilder().build()));
  }
  
  public UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(UncountedTerminatedPods item) {
    return withNewUncountedTerminatedPodsLike(java.util.Optional.ofNullable(buildUncountedTerminatedPods()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobStatusFluent that = (JobStatusFluent) o;
    if (!java.util.Objects.equals(active, that.active)) return false;
    if (!java.util.Objects.equals(completedIndexes, that.completedIndexes)) return false;
    if (!java.util.Objects.equals(completionTime, that.completionTime)) return false;
    if (!java.util.Objects.equals(conditions, that.conditions)) return false;
    if (!java.util.Objects.equals(failed, that.failed)) return false;
    if (!java.util.Objects.equals(failedIndexes, that.failedIndexes)) return false;
    if (!java.util.Objects.equals(ready, that.ready)) return false;
    if (!java.util.Objects.equals(startTime, that.startTime)) return false;
    if (!java.util.Objects.equals(succeeded, that.succeeded)) return false;
    if (!java.util.Objects.equals(terminating, that.terminating)) return false;
    if (!java.util.Objects.equals(uncountedTerminatedPods, that.uncountedTerminatedPods)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(active,  completedIndexes,  completionTime,  conditions,  failed,  failedIndexes,  ready,  startTime,  succeeded,  terminating,  uncountedTerminatedPods,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (active != null) { sb.append("active:"); sb.append(active + ","); }
    if (completedIndexes != null) { sb.append("completedIndexes:"); sb.append(completedIndexes + ","); }
    if (completionTime != null) { sb.append("completionTime:"); sb.append(completionTime + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (failed != null) { sb.append("failed:"); sb.append(failed + ","); }
    if (failedIndexes != null) { sb.append("failedIndexes:"); sb.append(failedIndexes + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (succeeded != null) { sb.append("succeeded:"); sb.append(succeeded + ","); }
    if (terminating != null) { sb.append("terminating:"); sb.append(terminating + ","); }
    if (uncountedTerminatedPods != null) { sb.append("uncountedTerminatedPods:"); sb.append(uncountedTerminatedPods + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ConditionsNested<N> extends JobConditionFluent<ConditionsNested<N>> implements Nested<N>{
    ConditionsNested(int index,JobCondition item) {
      this.index = index;
      this.builder = new JobConditionBuilder(this, item);
    }
    JobConditionBuilder builder;
    int index;
    
    public N and() {
      return (N) JobStatusFluent.this.setToConditions(index,builder.build());
    }
    
    public N endCondition() {
      return and();
    }
    
  
  }
  public class UncountedTerminatedPodsNested<N> extends UncountedTerminatedPodsFluent<UncountedTerminatedPodsNested<N>> implements Nested<N>{
    UncountedTerminatedPodsNested(UncountedTerminatedPods item) {
      this.builder = new UncountedTerminatedPodsBuilder(this, item);
    }
    UncountedTerminatedPodsBuilder builder;
    
    public N and() {
      return (N) JobStatusFluent.this.withUncountedTerminatedPods(builder.build());
    }
    
    public N endUncountedTerminatedPods() {
      return and();
    }
    
  
  }

}