package io.fabric8.kubernetes.api.model.batch.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.lang.Long;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class JobSpecFluent<A extends JobSpecFluent<A>> extends BaseFluent<A>{
  public JobSpecFluent() {
  }
  
  public JobSpecFluent(JobSpec instance) {
    this.copyInstance(instance);
  }
  private Long activeDeadlineSeconds;
  private Integer backoffLimit;
  private Integer backoffLimitPerIndex;
  private String completionMode;
  private Integer completions;
  private Boolean manualSelector;
  private Integer maxFailedIndexes;
  private Integer parallelism;
  private PodFailurePolicyBuilder podFailurePolicy;
  private String podReplacementPolicy;
  private LabelSelectorBuilder selector;
  private Boolean suspend;
  private PodTemplateSpecBuilder template;
  private Integer ttlSecondsAfterFinished;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(JobSpec instance) {
    instance = (instance != null ? instance : new JobSpec());
    if (instance != null) {
          this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
          this.withBackoffLimit(instance.getBackoffLimit());
          this.withBackoffLimitPerIndex(instance.getBackoffLimitPerIndex());
          this.withCompletionMode(instance.getCompletionMode());
          this.withCompletions(instance.getCompletions());
          this.withManualSelector(instance.getManualSelector());
          this.withMaxFailedIndexes(instance.getMaxFailedIndexes());
          this.withParallelism(instance.getParallelism());
          this.withPodFailurePolicy(instance.getPodFailurePolicy());
          this.withPodReplacementPolicy(instance.getPodReplacementPolicy());
          this.withSelector(instance.getSelector());
          this.withSuspend(instance.getSuspend());
          this.withTemplate(instance.getTemplate());
          this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
          this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
          this.withBackoffLimit(instance.getBackoffLimit());
          this.withBackoffLimitPerIndex(instance.getBackoffLimitPerIndex());
          this.withCompletionMode(instance.getCompletionMode());
          this.withCompletions(instance.getCompletions());
          this.withManualSelector(instance.getManualSelector());
          this.withMaxFailedIndexes(instance.getMaxFailedIndexes());
          this.withParallelism(instance.getParallelism());
          this.withPodFailurePolicy(instance.getPodFailurePolicy());
          this.withPodReplacementPolicy(instance.getPodReplacementPolicy());
          this.withSelector(instance.getSelector());
          this.withSuspend(instance.getSuspend());
          this.withTemplate(instance.getTemplate());
          this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  
  public A withActiveDeadlineSeconds(Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds = activeDeadlineSeconds;
    return (A) this;
  }
  
  public boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  
  public Integer getBackoffLimit() {
    return this.backoffLimit;
  }
  
  public A withBackoffLimit(Integer backoffLimit) {
    this.backoffLimit = backoffLimit;
    return (A) this;
  }
  
  public boolean hasBackoffLimit() {
    return this.backoffLimit != null;
  }
  
  public Integer getBackoffLimitPerIndex() {
    return this.backoffLimitPerIndex;
  }
  
  public A withBackoffLimitPerIndex(Integer backoffLimitPerIndex) {
    this.backoffLimitPerIndex = backoffLimitPerIndex;
    return (A) this;
  }
  
  public boolean hasBackoffLimitPerIndex() {
    return this.backoffLimitPerIndex != null;
  }
  
  public String getCompletionMode() {
    return this.completionMode;
  }
  
  public A withCompletionMode(String completionMode) {
    this.completionMode = completionMode;
    return (A) this;
  }
  
  public boolean hasCompletionMode() {
    return this.completionMode != null;
  }
  
  public Integer getCompletions() {
    return this.completions;
  }
  
  public A withCompletions(Integer completions) {
    this.completions = completions;
    return (A) this;
  }
  
  public boolean hasCompletions() {
    return this.completions != null;
  }
  
  public Boolean getManualSelector() {
    return this.manualSelector;
  }
  
  public A withManualSelector(Boolean manualSelector) {
    this.manualSelector = manualSelector;
    return (A) this;
  }
  
  public boolean hasManualSelector() {
    return this.manualSelector != null;
  }
  
  public Integer getMaxFailedIndexes() {
    return this.maxFailedIndexes;
  }
  
  public A withMaxFailedIndexes(Integer maxFailedIndexes) {
    this.maxFailedIndexes = maxFailedIndexes;
    return (A) this;
  }
  
  public boolean hasMaxFailedIndexes() {
    return this.maxFailedIndexes != null;
  }
  
  public Integer getParallelism() {
    return this.parallelism;
  }
  
  public A withParallelism(Integer parallelism) {
    this.parallelism = parallelism;
    return (A) this;
  }
  
  public boolean hasParallelism() {
    return this.parallelism != null;
  }
  
  public PodFailurePolicy buildPodFailurePolicy() {
    return this.podFailurePolicy != null ? this.podFailurePolicy.build() : null;
  }
  
  public A withPodFailurePolicy(PodFailurePolicy podFailurePolicy) {
    this._visitables.remove(this.podFailurePolicy);
    if (podFailurePolicy != null) {
        this.podFailurePolicy = new PodFailurePolicyBuilder(podFailurePolicy);
        this._visitables.get("podFailurePolicy").add(this.podFailurePolicy);
    } else {
        this.podFailurePolicy = null;
        this._visitables.get("podFailurePolicy").remove(this.podFailurePolicy);
    }
    return (A) this;
  }
  
  public boolean hasPodFailurePolicy() {
    return this.podFailurePolicy != null;
  }
  
  public PodFailurePolicyNested<A> withNewPodFailurePolicy() {
    return new PodFailurePolicyNested(null);
  }
  
  public PodFailurePolicyNested<A> withNewPodFailurePolicyLike(PodFailurePolicy item) {
    return new PodFailurePolicyNested(item);
  }
  
  public PodFailurePolicyNested<A> editPodFailurePolicy() {
    return withNewPodFailurePolicyLike(java.util.Optional.ofNullable(buildPodFailurePolicy()).orElse(null));
  }
  
  public PodFailurePolicyNested<A> editOrNewPodFailurePolicy() {
    return withNewPodFailurePolicyLike(java.util.Optional.ofNullable(buildPodFailurePolicy()).orElse(new PodFailurePolicyBuilder().build()));
  }
  
  public PodFailurePolicyNested<A> editOrNewPodFailurePolicyLike(PodFailurePolicy item) {
    return withNewPodFailurePolicyLike(java.util.Optional.ofNullable(buildPodFailurePolicy()).orElse(item));
  }
  
  public String getPodReplacementPolicy() {
    return this.podReplacementPolicy;
  }
  
  public A withPodReplacementPolicy(String podReplacementPolicy) {
    this.podReplacementPolicy = podReplacementPolicy;
    return (A) this;
  }
  
  public boolean hasPodReplacementPolicy() {
    return this.podReplacementPolicy != null;
  }
  
  public LabelSelector buildSelector() {
    return this.selector != null ? this.selector.build() : null;
  }
  
  public A withSelector(LabelSelector selector) {
    this._visitables.remove(this.selector);
    if (selector != null) {
        this.selector = new LabelSelectorBuilder(selector);
        this._visitables.get("selector").add(this.selector);
    } else {
        this.selector = null;
        this._visitables.get("selector").remove(this.selector);
    }
    return (A) this;
  }
  
  public boolean hasSelector() {
    return this.selector != null;
  }
  
  public SelectorNested<A> withNewSelector() {
    return new SelectorNested(null);
  }
  
  public SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new SelectorNested(item);
  }
  
  public SelectorNested<A> editSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(null));
  }
  
  public SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(java.util.Optional.ofNullable(buildSelector()).orElse(item));
  }
  
  public Boolean getSuspend() {
    return this.suspend;
  }
  
  public A withSuspend(Boolean suspend) {
    this.suspend = suspend;
    return (A) this;
  }
  
  public boolean hasSuspend() {
    return this.suspend != null;
  }
  
  public PodTemplateSpec buildTemplate() {
    return this.template != null ? this.template.build() : null;
  }
  
  public A withTemplate(PodTemplateSpec template) {
    this._visitables.remove(this.template);
    if (template != null) {
        this.template = new PodTemplateSpecBuilder(template);
        this._visitables.get("template").add(this.template);
    } else {
        this.template = null;
        this._visitables.get("template").remove(this.template);
    }
    return (A) this;
  }
  
  public boolean hasTemplate() {
    return this.template != null;
  }
  
  public TemplateNested<A> withNewTemplate() {
    return new TemplateNested(null);
  }
  
  public TemplateNested<A> withNewTemplateLike(PodTemplateSpec item) {
    return new TemplateNested(item);
  }
  
  public TemplateNested<A> editTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(null));
  }
  
  public TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(new PodTemplateSpecBuilder().build()));
  }
  
  public TemplateNested<A> editOrNewTemplateLike(PodTemplateSpec item) {
    return withNewTemplateLike(java.util.Optional.ofNullable(buildTemplate()).orElse(item));
  }
  
  public Integer getTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished;
  }
  
  public A withTtlSecondsAfterFinished(Integer ttlSecondsAfterFinished) {
    this.ttlSecondsAfterFinished = ttlSecondsAfterFinished;
    return (A) this;
  }
  
  public boolean hasTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished != null;
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobSpecFluent that = (JobSpecFluent) o;
    if (!java.util.Objects.equals(activeDeadlineSeconds, that.activeDeadlineSeconds)) return false;
    if (!java.util.Objects.equals(backoffLimit, that.backoffLimit)) return false;
    if (!java.util.Objects.equals(backoffLimitPerIndex, that.backoffLimitPerIndex)) return false;
    if (!java.util.Objects.equals(completionMode, that.completionMode)) return false;
    if (!java.util.Objects.equals(completions, that.completions)) return false;
    if (!java.util.Objects.equals(manualSelector, that.manualSelector)) return false;
    if (!java.util.Objects.equals(maxFailedIndexes, that.maxFailedIndexes)) return false;
    if (!java.util.Objects.equals(parallelism, that.parallelism)) return false;
    if (!java.util.Objects.equals(podFailurePolicy, that.podFailurePolicy)) return false;
    if (!java.util.Objects.equals(podReplacementPolicy, that.podReplacementPolicy)) return false;
    if (!java.util.Objects.equals(selector, that.selector)) return false;
    if (!java.util.Objects.equals(suspend, that.suspend)) return false;
    if (!java.util.Objects.equals(template, that.template)) return false;
    if (!java.util.Objects.equals(ttlSecondsAfterFinished, that.ttlSecondsAfterFinished)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  backoffLimit,  backoffLimitPerIndex,  completionMode,  completions,  manualSelector,  maxFailedIndexes,  parallelism,  podFailurePolicy,  podReplacementPolicy,  selector,  suspend,  template,  ttlSecondsAfterFinished,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (backoffLimit != null) { sb.append("backoffLimit:"); sb.append(backoffLimit + ","); }
    if (backoffLimitPerIndex != null) { sb.append("backoffLimitPerIndex:"); sb.append(backoffLimitPerIndex + ","); }
    if (completionMode != null) { sb.append("completionMode:"); sb.append(completionMode + ","); }
    if (completions != null) { sb.append("completions:"); sb.append(completions + ","); }
    if (manualSelector != null) { sb.append("manualSelector:"); sb.append(manualSelector + ","); }
    if (maxFailedIndexes != null) { sb.append("maxFailedIndexes:"); sb.append(maxFailedIndexes + ","); }
    if (parallelism != null) { sb.append("parallelism:"); sb.append(parallelism + ","); }
    if (podFailurePolicy != null) { sb.append("podFailurePolicy:"); sb.append(podFailurePolicy + ","); }
    if (podReplacementPolicy != null) { sb.append("podReplacementPolicy:"); sb.append(podReplacementPolicy + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (suspend != null) { sb.append("suspend:"); sb.append(suspend + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (ttlSecondsAfterFinished != null) { sb.append("ttlSecondsAfterFinished:"); sb.append(ttlSecondsAfterFinished + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withManualSelector() {
    return withManualSelector(true);
  }
  
  public A withSuspend() {
    return withSuspend(true);
  }
  public class PodFailurePolicyNested<N> extends PodFailurePolicyFluent<PodFailurePolicyNested<N>> implements Nested<N>{
    PodFailurePolicyNested(PodFailurePolicy item) {
      this.builder = new PodFailurePolicyBuilder(this, item);
    }
    PodFailurePolicyBuilder builder;
    
    public N and() {
      return (N) JobSpecFluent.this.withPodFailurePolicy(builder.build());
    }
    
    public N endPodFailurePolicy() {
      return and();
    }
    
  
  }
  public class SelectorNested<N> extends LabelSelectorFluent<SelectorNested<N>> implements Nested<N>{
    SelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) JobSpecFluent.this.withSelector(builder.build());
    }
    
    public N endSelector() {
      return and();
    }
    
  
  }
  public class TemplateNested<N> extends PodTemplateSpecFluent<TemplateNested<N>> implements Nested<N>{
    TemplateNested(PodTemplateSpec item) {
      this.builder = new PodTemplateSpecBuilder(this, item);
    }
    PodTemplateSpecBuilder builder;
    
    public N and() {
      return (N) JobSpecFluent.this.withTemplate(builder.build());
    }
    
    public N endTemplate() {
      return and();
    }
    
  
  }

}