package io.fabric8.kubernetes.api.model.batch.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobBuilder extends CronJobFluent<CronJobBuilder> implements VisitableBuilder<CronJob,CronJobBuilder>{
  public CronJobBuilder() {
    this(false);
  }
  public CronJobBuilder(Boolean validationEnabled) {
    this(new CronJob(), validationEnabled);
  }
  public CronJobBuilder(CronJobFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CronJob(), validationEnabled);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance) {
    this(fluent, instance, false);
  }
  public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new CronJob());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public CronJobBuilder(CronJob instance) {
    this(instance,false);
  }
  public CronJobBuilder(CronJob instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new CronJob());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  CronJobFluent<?> fluent;
  Boolean validationEnabled;
  public CronJob build() {
    CronJob buildable = new CronJob(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}