package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobSpecBuilder extends JobSpecFluent<JobSpecBuilder> implements VisitableBuilder<JobSpec,JobSpecBuilder>{
  public JobSpecBuilder() {
    this(false);
  }
  public JobSpecBuilder(Boolean validationEnabled) {
    this(new JobSpec(), validationEnabled);
  }
  public JobSpecBuilder(JobSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JobSpecBuilder(JobSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JobSpec(), validationEnabled);
  }
  public JobSpecBuilder(JobSpecFluent<?> fluent,JobSpec instance) {
    this(fluent, instance, false);
  }
  public JobSpecBuilder(JobSpecFluent<?> fluent,JobSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new JobSpec());

    if (instance != null) {
      fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      fluent.withBackoffLimit(instance.getBackoffLimit());
      fluent.withCompletionMode(instance.getCompletionMode());
      fluent.withCompletions(instance.getCompletions());
      fluent.withManualSelector(instance.getManualSelector());
      fluent.withParallelism(instance.getParallelism());
      fluent.withPodFailurePolicy(instance.getPodFailurePolicy());
      fluent.withSelector(instance.getSelector());
      fluent.withSuspend(instance.getSuspend());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
      fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      fluent.withBackoffLimit(instance.getBackoffLimit());
      fluent.withCompletionMode(instance.getCompletionMode());
      fluent.withCompletions(instance.getCompletions());
      fluent.withManualSelector(instance.getManualSelector());
      fluent.withParallelism(instance.getParallelism());
      fluent.withPodFailurePolicy(instance.getPodFailurePolicy());
      fluent.withSelector(instance.getSelector());
      fluent.withSuspend(instance.getSuspend());
      fluent.withTemplate(instance.getTemplate());
      fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JobSpecBuilder(JobSpec instance) {
    this(instance,false);
  }
  public JobSpecBuilder(JobSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new JobSpec());

    if (instance != null) {
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withBackoffLimit(instance.getBackoffLimit());
      this.withCompletionMode(instance.getCompletionMode());
      this.withCompletions(instance.getCompletions());
      this.withManualSelector(instance.getManualSelector());
      this.withParallelism(instance.getParallelism());
      this.withPodFailurePolicy(instance.getPodFailurePolicy());
      this.withSelector(instance.getSelector());
      this.withSuspend(instance.getSuspend());
      this.withTemplate(instance.getTemplate());
      this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
      this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds());
      this.withBackoffLimit(instance.getBackoffLimit());
      this.withCompletionMode(instance.getCompletionMode());
      this.withCompletions(instance.getCompletions());
      this.withManualSelector(instance.getManualSelector());
      this.withParallelism(instance.getParallelism());
      this.withPodFailurePolicy(instance.getPodFailurePolicy());
      this.withSelector(instance.getSelector());
      this.withSuspend(instance.getSuspend());
      this.withTemplate(instance.getTemplate());
      this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JobSpecFluent<?> fluent;
  Boolean validationEnabled;
  public JobSpec build() {
    JobSpec buildable = new JobSpec(fluent.getActiveDeadlineSeconds(),fluent.getBackoffLimit(),fluent.getCompletionMode(),fluent.getCompletions(),fluent.getManualSelector(),fluent.getParallelism(),fluent.buildPodFailurePolicy(),fluent.buildSelector(),fluent.getSuspend(),fluent.buildTemplate(),fluent.getTtlSecondsAfterFinished());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}