package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import io.fabric8.kubernetes.api.model.ListMeta;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import java.lang.Long;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface JobListFluent<A extends JobListFluent<A>> extends Fluent<A>{
  public String getApiVersion();
  public A withApiVersion(String apiVersion);
  public Boolean hasApiVersion();
  public A addToItems(int index,Job item);
  public A setToItems(int index,Job item);
  public A addToItems(io.fabric8.kubernetes.api.model.batch.v1.Job... items);
  public A addAllToItems(Collection<Job> items);
  public A removeFromItems(io.fabric8.kubernetes.api.model.batch.v1.Job... items);
  public A removeAllFromItems(Collection<Job> items);
  public A removeMatchingFromItems(Predicate<JobBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildItems instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Job> getItems();
  public List<Job> buildItems();
  public Job buildItem(int index);
  public Job buildFirstItem();
  public Job buildLastItem();
  public Job buildMatchingItem(Predicate<JobBuilder> predicate);
  public Boolean hasMatchingItem(Predicate<JobBuilder> predicate);
  public A withItems(List<Job> items);
  public A withItems(io.fabric8.kubernetes.api.model.batch.v1.Job... items);
  public Boolean hasItems();
  public JobListFluent.ItemsNested<A> addNewItem();
  public JobListFluent.ItemsNested<A> addNewItemLike(Job item);
  public JobListFluent.ItemsNested<A> setNewItemLike(int index,Job item);
  public JobListFluent.ItemsNested<A> editItem(int index);
  public JobListFluent.ItemsNested<A> editFirstItem();
  public JobListFluent.ItemsNested<A> editLastItem();
  public JobListFluent.ItemsNested<A> editMatchingItem(Predicate<JobBuilder> predicate);
  public String getKind();
  public A withKind(String kind);
  public Boolean hasKind();
  public ListMeta getMetadata();
  public A withMetadata(ListMeta metadata);
  public Boolean hasMetadata();
  public A withNewMetadata(String _continue,Long remainingItemCount,String resourceVersion,String selfLink);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ItemsNested<N> extends Nested<N>,JobFluent<JobListFluent.ItemsNested<N>>{
    public N and();
    public N endItem();
    
  }
  
}