package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobListBuilder extends JobListFluentImpl<JobListBuilder> implements VisitableBuilder<JobList,JobListBuilder>{
  public JobListBuilder() {
    this(false);
  }
  public JobListBuilder(Boolean validationEnabled) {
    this(new JobList(), validationEnabled);
  }
  public JobListBuilder(JobListFluent<?> fluent) {
    this(fluent, false);
  }
  public JobListBuilder(JobListFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new JobList(), validationEnabled);
  }
  public JobListBuilder(JobListFluent<?> fluent,JobList instance) {
    this(fluent, instance, false);
  }
  public JobListBuilder(JobListFluent<?> fluent,JobList instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withItems(instance.getItems());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JobListBuilder(JobList instance) {
    this(instance,false);
  }
  public JobListBuilder(JobList instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withItems(instance.getItems());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JobListFluent<?> fluent;
  Boolean validationEnabled;
  public JobList build() {
    JobList buildable = new JobList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}