package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobBuilder extends JobFluentImpl<JobBuilder> implements VisitableBuilder<Job,JobBuilder>{
  public JobBuilder() {
    this(false);
  }
  public JobBuilder(Boolean validationEnabled) {
    this(new Job(), validationEnabled);
  }
  public JobBuilder(JobFluent<?> fluent) {
    this(fluent, false);
  }
  public JobBuilder(JobFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Job(), validationEnabled);
  }
  public JobBuilder(JobFluent<?> fluent,Job instance) {
    this(fluent, instance, false);
  }
  public JobBuilder(JobFluent<?> fluent,Job instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public JobBuilder(Job instance) {
    this(instance,false);
  }
  public JobBuilder(Job instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  JobFluent<?> fluent;
  Boolean validationEnabled;
  public Job build() {
    Job buildable = new Job(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}