package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface JobStatusFluent<A extends JobStatusFluent<A>> extends Fluent<A>{
  public Integer getActive();
  public A withActive(Integer active);
  public Boolean hasActive();
  public String getCompletedIndexes();
  public A withCompletedIndexes(String completedIndexes);
  public Boolean hasCompletedIndexes();
  public String getCompletionTime();
  public A withCompletionTime(String completionTime);
  public Boolean hasCompletionTime();
  public A addToConditions(Integer index,JobCondition item);
  public A setToConditions(Integer index,JobCondition item);
  public A addToConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items);
  public A addAllToConditions(Collection<JobCondition> items);
  public A removeFromConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items);
  public A removeAllFromConditions(Collection<JobCondition> items);
  public A removeMatchingFromConditions(Predicate<JobConditionBuilder> predicate);
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<JobCondition> getConditions();
  public List<JobCondition> buildConditions();
  public JobCondition buildCondition(Integer index);
  public JobCondition buildFirstCondition();
  public JobCondition buildLastCondition();
  public JobCondition buildMatchingCondition(Predicate<JobConditionBuilder> predicate);
  public Boolean hasMatchingCondition(Predicate<JobConditionBuilder> predicate);
  public A withConditions(List<JobCondition> conditions);
  public A withConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... conditions);
  public Boolean hasConditions();
  public JobStatusFluent.ConditionsNested<A> addNewCondition();
  public JobStatusFluent.ConditionsNested<A> addNewConditionLike(JobCondition item);
  public JobStatusFluent.ConditionsNested<A> setNewConditionLike(Integer index,JobCondition item);
  public JobStatusFluent.ConditionsNested<A> editCondition(Integer index);
  public JobStatusFluent.ConditionsNested<A> editFirstCondition();
  public JobStatusFluent.ConditionsNested<A> editLastCondition();
  public JobStatusFluent.ConditionsNested<A> editMatchingCondition(Predicate<JobConditionBuilder> predicate);
  public Integer getFailed();
  public A withFailed(Integer failed);
  public Boolean hasFailed();
  public Integer getReady();
  public A withReady(Integer ready);
  public Boolean hasReady();
  public String getStartTime();
  public A withStartTime(String startTime);
  public Boolean hasStartTime();
  public Integer getSucceeded();
  public A withSucceeded(Integer succeeded);
  public Boolean hasSucceeded();
  
  /**
   * This method has been deprecated, please use method buildUncountedTerminatedPods instead.
   * @return The buildable object.
   */
  @Deprecated
  public UncountedTerminatedPods getUncountedTerminatedPods();
  public UncountedTerminatedPods buildUncountedTerminatedPods();
  public A withUncountedTerminatedPods(UncountedTerminatedPods uncountedTerminatedPods);
  public Boolean hasUncountedTerminatedPods();
  public JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods();
  public JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(UncountedTerminatedPods item);
  public JobStatusFluent.UncountedTerminatedPodsNested<A> editUncountedTerminatedPods();
  public JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods();
  public JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(UncountedTerminatedPods item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface ConditionsNested<N> extends Nested<N>,JobConditionFluent<JobStatusFluent.ConditionsNested<N>>{
    public N and();
    public N endCondition();
    
  }
  public interface UncountedTerminatedPodsNested<N> extends Nested<N>,UncountedTerminatedPodsFluent<JobStatusFluent.UncountedTerminatedPodsNested<N>>{
    public N and();
    public N endUncountedTerminatedPods();
    
  }
  
}