package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobTemplateSpecBuilder extends JobTemplateSpecFluentImpl<JobTemplateSpecBuilder> implements VisitableBuilder<JobTemplateSpec,io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecBuilder>{
  public JobTemplateSpecBuilder() {
    this(false);
  }
  public JobTemplateSpecBuilder(Boolean validationEnabled) {
    this(new JobTemplateSpec(), validationEnabled);
  }
  public JobTemplateSpecBuilder(JobTemplateSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JobTemplateSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JobTemplateSpec(), validationEnabled);
  }
  public JobTemplateSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec instance) {
    this(fluent, instance, false);
  }
  public JobTemplateSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobTemplateSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec instance) {
    this(instance,false);
  }
  public JobTemplateSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.JobTemplateSpec build() {
    JobTemplateSpec buildable = new JobTemplateSpec(fluent.getMetadata(),fluent.getSpec());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}