package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JobStatusFluentImpl<A extends JobStatusFluent<A>> extends BaseFluent<A> implements JobStatusFluent<A>{
  public JobStatusFluentImpl() {
  }
  public JobStatusFluentImpl(io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance) {
    this.withActive(instance.getActive()); 
    this.withCompletedIndexes(instance.getCompletedIndexes()); 
    this.withCompletionTime(instance.getCompletionTime()); 
    this.withConditions(instance.getConditions()); 
    this.withFailed(instance.getFailed()); 
    this.withReady(instance.getReady()); 
    this.withStartTime(instance.getStartTime()); 
    this.withSucceeded(instance.getSucceeded()); 
    this.withUncountedTerminatedPods(instance.getUncountedTerminatedPods()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Integer active;
  private String completedIndexes;
  private java.lang.String completionTime;
  private ArrayList<JobConditionBuilder> conditions = new java.util.ArrayList<JobConditionBuilder>();
  private java.lang.Integer failed;
  private java.lang.Integer ready;
  private java.lang.String startTime;
  private java.lang.Integer succeeded;
  private UncountedTerminatedPodsBuilder uncountedTerminatedPods;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.Integer getActive() {
    return this.active;
  }
  public A withActive(java.lang.Integer active) {
    this.active=active; return (A) this;
  }
  public Boolean hasActive() {
    return this.active != null;
  }
  public java.lang.String getCompletedIndexes() {
    return this.completedIndexes;
  }
  public A withCompletedIndexes(java.lang.String completedIndexes) {
    this.completedIndexes=completedIndexes; return (A) this;
  }
  public java.lang.Boolean hasCompletedIndexes() {
    return this.completedIndexes != null;
  }
  public java.lang.String getCompletionTime() {
    return this.completionTime;
  }
  public A withCompletionTime(java.lang.String completionTime) {
    this.completionTime=completionTime; return (A) this;
  }
  public java.lang.Boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(Collection<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> items) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> getConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> buildConditions() {
    return conditions != null ? build(conditions) : null;
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList(); for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public JobStatusFluent.ConditionsNested<A> addNewCondition() {
    return new JobStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    return new JobStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.Integer getFailed() {
    return this.failed;
  }
  public A withFailed(java.lang.Integer failed) {
    this.failed=failed; return (A) this;
  }
  public java.lang.Boolean hasFailed() {
    return this.failed != null;
  }
  public java.lang.Integer getReady() {
    return this.ready;
  }
  public A withReady(java.lang.Integer ready) {
    this.ready=ready; return (A) this;
  }
  public java.lang.Boolean hasReady() {
    return this.ready != null;
  }
  public java.lang.String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(java.lang.String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public java.lang.Boolean hasStartTime() {
    return this.startTime != null;
  }
  public java.lang.Integer getSucceeded() {
    return this.succeeded;
  }
  public A withSucceeded(java.lang.Integer succeeded) {
    this.succeeded=succeeded; return (A) this;
  }
  public java.lang.Boolean hasSucceeded() {
    return this.succeeded != null;
  }
  
  /**
   * This method has been deprecated, please use method buildUncountedTerminatedPods instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods getUncountedTerminatedPods() {
    return this.uncountedTerminatedPods!=null ?this.uncountedTerminatedPods.build():null;
  }
  public io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods buildUncountedTerminatedPods() {
    return this.uncountedTerminatedPods!=null ?this.uncountedTerminatedPods.build():null;
  }
  public A withUncountedTerminatedPods(io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods uncountedTerminatedPods) {
    _visitables.get("uncountedTerminatedPods").remove(this.uncountedTerminatedPods);
    if (uncountedTerminatedPods!=null){ this.uncountedTerminatedPods= new UncountedTerminatedPodsBuilder(uncountedTerminatedPods); _visitables.get("uncountedTerminatedPods").add(this.uncountedTerminatedPods);} return (A) this;
  }
  public java.lang.Boolean hasUncountedTerminatedPods() {
    return this.uncountedTerminatedPods != null;
  }
  public JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPods() {
    return new JobStatusFluentImpl.UncountedTerminatedPodsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.UncountedTerminatedPodsNested<A> withNewUncountedTerminatedPodsLike(io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods item) {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl.UncountedTerminatedPodsNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.UncountedTerminatedPodsNested<A> editUncountedTerminatedPods() {
    return withNewUncountedTerminatedPodsLike(getUncountedTerminatedPods());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPods() {
    return withNewUncountedTerminatedPodsLike(getUncountedTerminatedPods() != null ? getUncountedTerminatedPods(): new io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPodsBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.UncountedTerminatedPodsNested<A> editOrNewUncountedTerminatedPodsLike(io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPods item) {
    return withNewUncountedTerminatedPodsLike(getUncountedTerminatedPods() != null ? getUncountedTerminatedPods(): item);
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JobStatusFluentImpl that = (JobStatusFluentImpl) o;
    if (active != null ? !active.equals(that.active) :that.active != null) return false;
    if (completedIndexes != null ? !completedIndexes.equals(that.completedIndexes) :that.completedIndexes != null) return false;
    if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (failed != null ? !failed.equals(that.failed) :that.failed != null) return false;
    if (ready != null ? !ready.equals(that.ready) :that.ready != null) return false;
    if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
    if (succeeded != null ? !succeeded.equals(that.succeeded) :that.succeeded != null) return false;
    if (uncountedTerminatedPods != null ? !uncountedTerminatedPods.equals(that.uncountedTerminatedPods) :that.uncountedTerminatedPods != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(active,  completedIndexes,  completionTime,  conditions,  failed,  ready,  startTime,  succeeded,  uncountedTerminatedPods,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (active != null) { sb.append("active:"); sb.append(active + ","); }
    if (completedIndexes != null) { sb.append("completedIndexes:"); sb.append(completedIndexes + ","); }
    if (completionTime != null) { sb.append("completionTime:"); sb.append(completionTime + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (failed != null) { sb.append("failed:"); sb.append(failed + ","); }
    if (ready != null) { sb.append("ready:"); sb.append(ready + ","); }
    if (startTime != null) { sb.append("startTime:"); sb.append(startTime + ","); }
    if (succeeded != null) { sb.append("succeeded:"); sb.append(succeeded + ","); }
    if (uncountedTerminatedPods != null) { sb.append("uncountedTerminatedPods:"); sb.append(uncountedTerminatedPods + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ConditionsNestedImpl<N> extends JobConditionFluentImpl<JobStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<N>,Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
      this.index = index;
      this.builder = new JobConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) JobStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  class UncountedTerminatedPodsNestedImpl<N> extends UncountedTerminatedPodsFluentImpl<JobStatusFluent.UncountedTerminatedPodsNested<N>> implements io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.UncountedTerminatedPodsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UncountedTerminatedPodsNestedImpl(UncountedTerminatedPods item) {
      this.builder = new UncountedTerminatedPodsBuilder(this, item);
    }
    UncountedTerminatedPodsNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPodsBuilder(this);
    }
    io.fabric8.kubernetes.api.model.batch.v1.UncountedTerminatedPodsBuilder builder;
    public N and() {
      return (N) JobStatusFluentImpl.this.withUncountedTerminatedPods(builder.build());
    }
    public N endUncountedTerminatedPods() {
      return and();
    }
    
  }
  
}