package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class JobSpecFluentImpl<A extends JobSpecFluent<A>> extends BaseFluent<A> implements JobSpecFluent<A>{
  public JobSpecFluentImpl() {
  }
  public JobSpecFluentImpl(io.fabric8.kubernetes.api.model.batch.v1.JobSpec instance) {
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withBackoffLimit(instance.getBackoffLimit()); 
    this.withCompletionMode(instance.getCompletionMode()); 
    this.withCompletions(instance.getCompletions()); 
    this.withManualSelector(instance.getManualSelector()); 
    this.withParallelism(instance.getParallelism()); 
    this.withSelector(instance.getSelector()); 
    this.withSuspend(instance.getSuspend()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private Long activeDeadlineSeconds;
  private Integer backoffLimit;
  private String completionMode;
  private java.lang.Integer completions;
  private Boolean manualSelector;
  private java.lang.Integer parallelism;
  private LabelSelectorBuilder selector;
  private java.lang.Boolean suspend;
  private PodTemplateSpecBuilder template;
  private java.lang.Integer ttlSecondsAfterFinished;
  private Map<java.lang.String,Object> additionalProperties;
  public java.lang.Long getActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds;
  }
  public A withActiveDeadlineSeconds(java.lang.Long activeDeadlineSeconds) {
    this.activeDeadlineSeconds=activeDeadlineSeconds; return (A) this;
  }
  public java.lang.Boolean hasActiveDeadlineSeconds() {
    return this.activeDeadlineSeconds != null;
  }
  public java.lang.Integer getBackoffLimit() {
    return this.backoffLimit;
  }
  public A withBackoffLimit(java.lang.Integer backoffLimit) {
    this.backoffLimit=backoffLimit; return (A) this;
  }
  public java.lang.Boolean hasBackoffLimit() {
    return this.backoffLimit != null;
  }
  public java.lang.String getCompletionMode() {
    return this.completionMode;
  }
  public A withCompletionMode(java.lang.String completionMode) {
    this.completionMode=completionMode; return (A) this;
  }
  public java.lang.Boolean hasCompletionMode() {
    return this.completionMode != null;
  }
  public java.lang.Integer getCompletions() {
    return this.completions;
  }
  public A withCompletions(java.lang.Integer completions) {
    this.completions=completions; return (A) this;
  }
  public java.lang.Boolean hasCompletions() {
    return this.completions != null;
  }
  public java.lang.Boolean getManualSelector() {
    return this.manualSelector;
  }
  public A withManualSelector(java.lang.Boolean manualSelector) {
    this.manualSelector=manualSelector; return (A) this;
  }
  public java.lang.Boolean hasManualSelector() {
    return this.manualSelector != null;
  }
  public java.lang.Integer getParallelism() {
    return this.parallelism;
  }
  public A withParallelism(java.lang.Integer parallelism) {
    this.parallelism=parallelism; return (A) this;
  }
  public java.lang.Boolean hasParallelism() {
    return this.parallelism != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public JobSpecFluent.SelectorNested<A> withNewSelector() {
    return new JobSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new JobSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public java.lang.Boolean getSuspend() {
    return this.suspend;
  }
  public A withSuspend(java.lang.Boolean suspend) {
    this.suspend=suspend; return (A) this;
  }
  public java.lang.Boolean hasSuspend() {
    return this.suspend != null;
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
    return this.template!=null ?this.template.build():null;
  }
  public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public JobSpecFluent.TemplateNested<A> withNewTemplate() {
    return new JobSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  public java.lang.Integer getTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished;
  }
  public A withTtlSecondsAfterFinished(java.lang.Integer ttlSecondsAfterFinished) {
    this.ttlSecondsAfterFinished=ttlSecondsAfterFinished; return (A) this;
  }
  public java.lang.Boolean hasTtlSecondsAfterFinished() {
    return this.ttlSecondsAfterFinished != null;
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JobSpecFluentImpl that = (JobSpecFluentImpl) o;
    if (activeDeadlineSeconds != null ? !activeDeadlineSeconds.equals(that.activeDeadlineSeconds) :that.activeDeadlineSeconds != null) return false;
    if (backoffLimit != null ? !backoffLimit.equals(that.backoffLimit) :that.backoffLimit != null) return false;
    if (completionMode != null ? !completionMode.equals(that.completionMode) :that.completionMode != null) return false;
    if (completions != null ? !completions.equals(that.completions) :that.completions != null) return false;
    if (manualSelector != null ? !manualSelector.equals(that.manualSelector) :that.manualSelector != null) return false;
    if (parallelism != null ? !parallelism.equals(that.parallelism) :that.parallelism != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (suspend != null ? !suspend.equals(that.suspend) :that.suspend != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (ttlSecondsAfterFinished != null ? !ttlSecondsAfterFinished.equals(that.ttlSecondsAfterFinished) :that.ttlSecondsAfterFinished != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(activeDeadlineSeconds,  backoffLimit,  completionMode,  completions,  manualSelector,  parallelism,  selector,  suspend,  template,  ttlSecondsAfterFinished,  additionalProperties,  super.hashCode());
  }
  public java.lang.String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (activeDeadlineSeconds != null) { sb.append("activeDeadlineSeconds:"); sb.append(activeDeadlineSeconds + ","); }
    if (backoffLimit != null) { sb.append("backoffLimit:"); sb.append(backoffLimit + ","); }
    if (completionMode != null) { sb.append("completionMode:"); sb.append(completionMode + ","); }
    if (completions != null) { sb.append("completions:"); sb.append(completions + ","); }
    if (manualSelector != null) { sb.append("manualSelector:"); sb.append(manualSelector + ","); }
    if (parallelism != null) { sb.append("parallelism:"); sb.append(parallelism + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (suspend != null) { sb.append("suspend:"); sb.append(suspend + ","); }
    if (template != null) { sb.append("template:"); sb.append(template + ","); }
    if (ttlSecondsAfterFinished != null) { sb.append("ttlSecondsAfterFinished:"); sb.append(ttlSecondsAfterFinished + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withManualSelector() {
    return withManualSelector(true);
  }
  public A withSuspend() {
    return withSuspend(true);
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<JobSpecFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) JobSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TemplateNestedImpl<N> extends PodTemplateSpecFluentImpl<JobSpecFluent.TemplateNested<N>> implements io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;
    public N and() {
      return (N) JobSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  
}