package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobListBuilder extends JobListFluentImpl<JobListBuilder> implements VisitableBuilder<JobList,io.fabric8.kubernetes.api.model.batch.v1.JobListBuilder>{
  public JobListBuilder() {
    this(false);
  }
  public JobListBuilder(Boolean validationEnabled) {
    this(new JobList(), validationEnabled);
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobListFluent<?> fluent) {
    this(fluent, false);
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobListFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JobList(), validationEnabled);
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobListFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobList instance) {
    this(fluent, instance, false);
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobListFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobList instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withItems(instance.getItems()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobList instance) {
    this(instance,false);
  }
  public JobListBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobList instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withItems(instance.getItems()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.JobListFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.JobList build() {
    JobList buildable = new JobList(fluent.getApiVersion(),fluent.getItems(),fluent.getKind(),fluent.getMetadata());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}