package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobConditionBuilder extends JobConditionFluentImpl<JobConditionBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.batch.v1.JobCondition,io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>{
  public JobConditionBuilder() {
    this(false);
  }
  public JobConditionBuilder(Boolean validationEnabled) {
    this(new JobCondition(), validationEnabled);
  }
  public JobConditionBuilder(JobConditionFluent<?> fluent) {
    this(fluent, false);
  }
  public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JobCondition(), validationEnabled);
  }
  public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance) {
    this(fluent, instance, false);
  }
  public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withLastProbeTime(instance.getLastProbeTime()); 
    fluent.withLastTransitionTime(instance.getLastTransitionTime()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance) {
    this(instance,false);
  }
  public JobConditionBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobCondition instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withLastProbeTime(instance.getLastProbeTime()); 
    this.withLastTransitionTime(instance.getLastTransitionTime()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withStatus(instance.getStatus()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition build() {
    JobCondition buildable = new JobCondition(fluent.getLastProbeTime(),fluent.getLastTransitionTime(),fluent.getMessage(),fluent.getReason(),fluent.getStatus(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}