package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class JobBuilder extends JobFluentImpl<JobBuilder> implements VisitableBuilder<Job,io.fabric8.kubernetes.api.model.batch.v1.JobBuilder>{
  public JobBuilder() {
    this(false);
  }
  public JobBuilder(Boolean validationEnabled) {
    this(new Job(), validationEnabled);
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobFluent<?> fluent) {
    this(fluent, false);
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new Job(), validationEnabled);
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.Job instance) {
    this(fluent, instance, false);
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.Job instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.Job instance) {
    this(instance,false);
  }
  public JobBuilder(io.fabric8.kubernetes.api.model.batch.v1.Job instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.JobFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.Job build() {
    Job buildable = new Job(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}