package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobStatusBuilder extends CronJobStatusFluentImpl<CronJobStatusBuilder> implements VisitableBuilder<CronJobStatus,io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusBuilder>{
  public CronJobStatusBuilder() {
    this(false);
  }
  public CronJobStatusBuilder(Boolean validationEnabled) {
    this(new CronJobStatus(), validationEnabled);
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CronJobStatus(), validationEnabled);
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus instance) {
    this(fluent, instance, false);
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActive(instance.getActive()); 
    fluent.withLastScheduleTime(instance.getLastScheduleTime()); 
    fluent.withLastSuccessfulTime(instance.getLastSuccessfulTime()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus instance) {
    this(instance,false);
  }
  public CronJobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActive(instance.getActive()); 
    this.withLastScheduleTime(instance.getLastScheduleTime()); 
    this.withLastSuccessfulTime(instance.getLastSuccessfulTime()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.CronJobStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.CronJobStatus build() {
    CronJobStatus buildable = new CronJobStatus(fluent.getActive(),fluent.getLastScheduleTime(),fluent.getLastSuccessfulTime());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}