package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CronJobBuilder extends CronJobFluentImpl<CronJobBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.batch.v1.CronJob,CronJobBuilder>{
  public CronJobBuilder() {
    this(false);
  }
  public CronJobBuilder(Boolean validationEnabled) {
    this(new CronJob(), validationEnabled);
  }
  public CronJobBuilder(CronJobFluent<?> fluent) {
    this(fluent, false);
  }
  public CronJobBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new CronJob(), validationEnabled);
  }
  public CronJobBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.CronJob instance) {
    this(fluent, instance, false);
  }
  public CronJobBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.CronJob instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CronJobBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJob instance) {
    this(instance,false);
  }
  public CronJobBuilder(io.fabric8.kubernetes.api.model.batch.v1.CronJob instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.CronJobFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.CronJob build() {
    CronJob buildable = new CronJob(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}