package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
public class JobStatusFluentImpl<A extends io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<A>{
  public JobStatusFluentImpl() {
  }
  public JobStatusFluentImpl(io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance) {
    this.withActive(instance.getActive()); 
    this.withCompletedIndexes(instance.getCompletedIndexes()); 
    this.withCompletionTime(instance.getCompletionTime()); 
    this.withConditions(instance.getConditions()); 
    this.withFailed(instance.getFailed()); 
    this.withStartTime(instance.getStartTime()); 
    this.withSucceeded(instance.getSucceeded()); 
  }
  private java.lang.Integer active;
  private java.lang.String completedIndexes;
  private java.lang.String completionTime;
  private java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> conditions =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();
  private java.lang.Integer failed;
  private java.lang.String startTime;
  private java.lang.Integer succeeded;
  public java.lang.Integer getActive() {
    return this.active;
  }
  public A withActive(java.lang.Integer active) {
    this.active=active; return (A) this;
  }
  public java.lang.Boolean hasActive() {
    return this.active != null;
  }
  public java.lang.String getCompletedIndexes() {
    return this.completedIndexes;
  }
  public A withCompletedIndexes(java.lang.String completedIndexes) {
    this.completedIndexes=completedIndexes; return (A) this;
  }
  public java.lang.Boolean hasCompletedIndexes() {
    return this.completedIndexes != null;
  }
  
  /**
   * Method is deprecated. use withCompletedIndexes instead.
   */
  @java.lang.Deprecated
  public A withNewCompletedIndexes(java.lang.String arg0) {
    return (A)withCompletedIndexes(new String(arg0));
  }
  public java.lang.String getCompletionTime() {
    return this.completionTime;
  }
  public A withCompletionTime(java.lang.String completionTime) {
    this.completionTime=completionTime; return (A) this;
  }
  public java.lang.Boolean hasCompletionTime() {
    return this.completionTime != null;
  }
  
  /**
   * Method is deprecated. use withCompletionTime instead.
   */
  @java.lang.Deprecated
  public A withNewCompletionTime(java.lang.String arg0) {
    return (A)withCompletionTime(new String(arg0));
  }
  public A addToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(index >= 0 ? index : _visitables.get("conditions").size(), builder);this.conditions.add(index >= 0 ? index : conditions.size(), builder); return (A)this;
  }
  public A setToConditions(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);
    if (index < 0 || index >= _visitables.get("conditions").size()) { _visitables.get("conditions").add(builder); } else { _visitables.get("conditions").set(index, builder);}
    if (index < 0 || index >= conditions.size()) { conditions.add(builder); } else { conditions.set(index, builder);}
     return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A addAllToConditions(java.util.Collection<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> items) {
    if (this.conditions == null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>();}
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").add(builder);this.conditions.add(builder);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... items) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeAllFromConditions(java.util.Collection<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> items) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : items) {io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(item);_visitables.get("conditions").remove(builder);if (this.conditions != null) {this.conditions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromConditions(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    if (conditions == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> each = conditions.iterator();
    final List visitables = _visitables.get("conditions");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildConditions instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> getConditions() {
    return build(conditions);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> buildConditions() {
    return build(conditions);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildCondition(java.lang.Integer index) {
    return this.conditions.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildFirstCondition() {
    return this.conditions.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildLastCondition() {
    return this.conditions.get(conditions.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobCondition buildMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder item: conditions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(java.util.List<io.fabric8.kubernetes.api.model.batch.v1.JobCondition> conditions) {
    if (this.conditions != null) { _visitables.get("conditions").removeAll(this.conditions);}
    if (conditions != null) {this.conditions = new java.util.ArrayList<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder>(); for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.batch.v1.JobCondition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (io.fabric8.kubernetes.api.model.batch.v1.JobCondition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public java.lang.Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> addNewCondition() {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl.ConditionsNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> addNewConditionLike(io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl.ConditionsNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> setNewConditionLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
    return new io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl.ConditionsNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editCondition(java.lang.Integer index) {
    if (conditions.size() <= index) throw new RuntimeException("Can't edit conditions. Index exceeds size.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editFirstCondition() {
    if (conditions.size() == 0) throw new RuntimeException("Can't edit first conditions. The list is empty.");
    return setNewConditionLike(0, buildCondition(0));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editLastCondition() {
    int index = conditions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last conditions. The list is empty.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<A> editMatchingCondition(java.util.function.Predicate<io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<conditions.size();i++) { 
    if (predicate.test(conditions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching conditions. No match found.");
    return setNewConditionLike(index, buildCondition(index));
  }
  public java.lang.Integer getFailed() {
    return this.failed;
  }
  public A withFailed(java.lang.Integer failed) {
    this.failed=failed; return (A) this;
  }
  public java.lang.Boolean hasFailed() {
    return this.failed != null;
  }
  public java.lang.String getStartTime() {
    return this.startTime;
  }
  public A withStartTime(java.lang.String startTime) {
    this.startTime=startTime; return (A) this;
  }
  public java.lang.Boolean hasStartTime() {
    return this.startTime != null;
  }
  
  /**
   * Method is deprecated. use withStartTime instead.
   */
  @java.lang.Deprecated
  public A withNewStartTime(java.lang.String arg0) {
    return (A)withStartTime(new String(arg0));
  }
  public java.lang.Integer getSucceeded() {
    return this.succeeded;
  }
  public A withSucceeded(java.lang.Integer succeeded) {
    this.succeeded=succeeded; return (A) this;
  }
  public java.lang.Boolean hasSucceeded() {
    return this.succeeded != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    JobStatusFluentImpl that = (JobStatusFluentImpl) o;
    if (active != null ? !active.equals(that.active) :that.active != null) return false;
    if (completedIndexes != null ? !completedIndexes.equals(that.completedIndexes) :that.completedIndexes != null) return false;
    if (completionTime != null ? !completionTime.equals(that.completionTime) :that.completionTime != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (failed != null ? !failed.equals(that.failed) :that.failed != null) return false;
    if (startTime != null ? !startTime.equals(that.startTime) :that.startTime != null) return false;
    if (succeeded != null ? !succeeded.equals(that.succeeded) :that.succeeded != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(active,  completedIndexes,  completionTime,  conditions,  failed,  startTime,  succeeded,  super.hashCode());
  }
  public class ConditionsNestedImpl<N> extends io.fabric8.kubernetes.api.model.batch.v1.JobConditionFluentImpl<io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<N>> implements io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent.ConditionsNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    ConditionsNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.batch.v1.JobCondition item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(this, item);
    }
    ConditionsNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder(this);
    }
    io.fabric8.kubernetes.api.model.batch.v1.JobConditionBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) JobStatusFluentImpl.this.setToConditions(index,builder.build());
    }
    public N endCondition() {
      return and();
    }
    
  }
  
}