package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class JobStatusBuilder extends io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluentImpl<io.fabric8.kubernetes.api.model.batch.v1.JobStatusBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.batch.v1.JobStatus,io.fabric8.kubernetes.api.model.batch.v1.JobStatusBuilder> {

    io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public JobStatusBuilder() {
        this(true);
    }

    public JobStatusBuilder(java.lang.Boolean validationEnabled) {
        this(new JobStatus(), validationEnabled);
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<?> fluent) {
        this(fluent, true);
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new JobStatus(), validationEnabled);
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance) {
        this(fluent, instance, true);
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withActive(instance.getActive()); 
        fluent.withCompletedIndexes(instance.getCompletedIndexes()); 
        fluent.withCompletionTime(instance.getCompletionTime()); 
        fluent.withConditions(instance.getConditions()); 
        fluent.withFailed(instance.getFailed()); 
        fluent.withStartTime(instance.getStartTime()); 
        fluent.withSucceeded(instance.getSucceeded()); 
        this.validationEnabled = validationEnabled; 
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance) {
        this(instance,true);
    }

    public JobStatusBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobStatus instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withActive(instance.getActive()); 
        this.withCompletedIndexes(instance.getCompletedIndexes()); 
        this.withCompletionTime(instance.getCompletionTime()); 
        this.withConditions(instance.getConditions()); 
        this.withFailed(instance.getFailed()); 
        this.withStartTime(instance.getStartTime()); 
        this.withSucceeded(instance.getSucceeded()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.batch.v1.JobStatus build() {
        JobStatus buildable = new JobStatus(fluent.getActive(),fluent.getCompletedIndexes(),fluent.getCompletionTime(),fluent.getConditions(),fluent.getFailed(),fluent.getStartTime(),fluent.getSucceeded());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        JobStatusBuilder that = (JobStatusBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
