package io.fabric8.kubernetes.api.model.batch;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class CronJobBuilder extends CronJobFluentImpl<CronJobBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<CronJob,CronJobBuilder> {

    CronJobFluent<?> fluent;
    Boolean validationEnabled;

    public CronJobBuilder() {
        this(true);
    }

    public CronJobBuilder(Boolean validationEnabled) {
        this(new CronJob(), validationEnabled);
    }

    public CronJobBuilder(CronJobFluent<?> fluent) {
        this(fluent, true);
    }

    public CronJobBuilder(CronJobFluent<?> fluent,Boolean validationEnabled) {
        this(fluent, new CronJob(), validationEnabled);
    }

    public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance) {
        this(fluent, instance, true);
    }

    public CronJobBuilder(CronJobFluent<?> fluent,CronJob instance,Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiVersion(instance.getApiVersion()); 
        fluent.withKind(instance.getKind()); 
        fluent.withMetadata(instance.getMetadata()); 
        fluent.withSpec(instance.getSpec()); 
        fluent.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public CronJobBuilder(CronJob instance) {
        this(instance,true);
    }

    public CronJobBuilder(CronJob instance,Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withSpec(instance.getSpec()); 
        this.withStatus(instance.getStatus()); 
        this.validationEnabled = validationEnabled; 
    }

    public CronJob build() {
        CronJob buildable = new CronJob(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
        return buildable;
    }

    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        CronJobBuilder that = (CronJobBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
