package io.fabric8.kubernetes.api.model.batch.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;
public class JobSpecBuilder extends io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluentImpl<io.fabric8.kubernetes.api.model.batch.v1.JobSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.batch.v1.JobSpec,io.fabric8.kubernetes.api.model.batch.v1.JobSpecBuilder>{
  public JobSpecBuilder() {
    this(false);
  }
  public JobSpecBuilder(java.lang.Boolean validationEnabled) {
    this(new JobSpec(), validationEnabled);
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new JobSpec(), validationEnabled);
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobSpec instance) {
    this(fluent, instance, false);
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.batch.v1.JobSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    fluent.withBackoffLimit(instance.getBackoffLimit()); 
    fluent.withCompletionMode(instance.getCompletionMode()); 
    fluent.withCompletions(instance.getCompletions()); 
    fluent.withManualSelector(instance.getManualSelector()); 
    fluent.withParallelism(instance.getParallelism()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withSuspend(instance.getSuspend()); 
    fluent.withTemplate(instance.getTemplate()); 
    fluent.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpec instance) {
    this(instance,false);
  }
  public JobSpecBuilder(io.fabric8.kubernetes.api.model.batch.v1.JobSpec instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withActiveDeadlineSeconds(instance.getActiveDeadlineSeconds()); 
    this.withBackoffLimit(instance.getBackoffLimit()); 
    this.withCompletionMode(instance.getCompletionMode()); 
    this.withCompletions(instance.getCompletions()); 
    this.withManualSelector(instance.getManualSelector()); 
    this.withParallelism(instance.getParallelism()); 
    this.withSelector(instance.getSelector()); 
    this.withSuspend(instance.getSuspend()); 
    this.withTemplate(instance.getTemplate()); 
    this.withTtlSecondsAfterFinished(instance.getTtlSecondsAfterFinished()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.batch.v1.JobSpecFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.batch.v1.JobSpec build() {
    JobSpec buildable = new JobSpec(fluent.getActiveDeadlineSeconds(),fluent.getBackoffLimit(),fluent.getCompletionMode(),fluent.getCompletions(),fluent.getManualSelector(),fluent.getParallelism(),fluent.getSelector(),fluent.getSuspend(),fluent.getTemplate(),fluent.getTtlSecondsAfterFinished());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    JobSpecBuilder that = (JobSpecBuilder) o;
    if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

    if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
  }
  
}