/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ContainerResourceMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ExternalMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricSpec;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.PodsMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.PodsMetricSourceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.PodsMetricSourceFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MetricSpecFluent<A extends MetricSpecFluent<A>>
extends BaseFluent<A> {
    private ContainerResourceMetricSourceBuilder containerResource;
    private ExternalMetricSourceBuilder external;
    private ObjectMetricSourceBuilder object;
    private PodsMetricSourceBuilder pods;
    private ResourceMetricSourceBuilder resource;
    private String type;
    private Map<String, Object> additionalProperties;

    public MetricSpecFluent() {
    }

    public MetricSpecFluent(MetricSpec instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MetricSpec instance) {
        MetricSpec metricSpec = instance = instance != null ? instance : new MetricSpec();
        if (instance != null) {
            this.withContainerResource(instance.getContainerResource());
            this.withExternal(instance.getExternal());
            this.withObject(instance.getObject());
            this.withPods(instance.getPods());
            this.withResource(instance.getResource());
            this.withType(instance.getType());
            this.withContainerResource(instance.getContainerResource());
            this.withExternal(instance.getExternal());
            this.withObject(instance.getObject());
            this.withPods(instance.getPods());
            this.withResource(instance.getResource());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public ContainerResourceMetricSource buildContainerResource() {
        return this.containerResource != null ? this.containerResource.build() : null;
    }

    public A withContainerResource(ContainerResourceMetricSource containerResource) {
        this._visitables.remove((Object)this.containerResource);
        if (containerResource != null) {
            this.containerResource = new ContainerResourceMetricSourceBuilder(containerResource);
            this._visitables.get((Object)"containerResource").add(this.containerResource);
        } else {
            this.containerResource = null;
            this._visitables.get((Object)"containerResource").remove((Object)this.containerResource);
        }
        return (A)((Object)this);
    }

    public boolean hasContainerResource() {
        return this.containerResource != null;
    }

    public ContainerResourceNested<A> withNewContainerResource() {
        return new ContainerResourceNested(null);
    }

    public ContainerResourceNested<A> withNewContainerResourceLike(ContainerResourceMetricSource item) {
        return new ContainerResourceNested(item);
    }

    public ContainerResourceNested<A> editContainerResource() {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(null));
    }

    public ContainerResourceNested<A> editOrNewContainerResource() {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(new ContainerResourceMetricSourceBuilder().build()));
    }

    public ContainerResourceNested<A> editOrNewContainerResourceLike(ContainerResourceMetricSource item) {
        return this.withNewContainerResourceLike(Optional.ofNullable(this.buildContainerResource()).orElse(item));
    }

    public ExternalMetricSource buildExternal() {
        return this.external != null ? this.external.build() : null;
    }

    public A withExternal(ExternalMetricSource external) {
        this._visitables.remove((Object)this.external);
        if (external != null) {
            this.external = new ExternalMetricSourceBuilder(external);
            this._visitables.get((Object)"external").add(this.external);
        } else {
            this.external = null;
            this._visitables.get((Object)"external").remove((Object)this.external);
        }
        return (A)((Object)this);
    }

    public boolean hasExternal() {
        return this.external != null;
    }

    public ExternalNested<A> withNewExternal() {
        return new ExternalNested(null);
    }

    public ExternalNested<A> withNewExternalLike(ExternalMetricSource item) {
        return new ExternalNested(item);
    }

    public ExternalNested<A> editExternal() {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(null));
    }

    public ExternalNested<A> editOrNewExternal() {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(new ExternalMetricSourceBuilder().build()));
    }

    public ExternalNested<A> editOrNewExternalLike(ExternalMetricSource item) {
        return this.withNewExternalLike(Optional.ofNullable(this.buildExternal()).orElse(item));
    }

    public ObjectMetricSource buildObject() {
        return this.object != null ? this.object.build() : null;
    }

    public A withObject(ObjectMetricSource object) {
        this._visitables.remove((Object)this.object);
        if (object != null) {
            this.object = new ObjectMetricSourceBuilder(object);
            this._visitables.get((Object)"object").add(this.object);
        } else {
            this.object = null;
            this._visitables.get((Object)"object").remove((Object)this.object);
        }
        return (A)((Object)this);
    }

    public boolean hasObject() {
        return this.object != null;
    }

    public ObjectNested<A> withNewObject() {
        return new ObjectNested(null);
    }

    public ObjectNested<A> withNewObjectLike(ObjectMetricSource item) {
        return new ObjectNested(item);
    }

    public ObjectNested<A> editObject() {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(null));
    }

    public ObjectNested<A> editOrNewObject() {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(new ObjectMetricSourceBuilder().build()));
    }

    public ObjectNested<A> editOrNewObjectLike(ObjectMetricSource item) {
        return this.withNewObjectLike(Optional.ofNullable(this.buildObject()).orElse(item));
    }

    public PodsMetricSource buildPods() {
        return this.pods != null ? this.pods.build() : null;
    }

    public A withPods(PodsMetricSource pods) {
        this._visitables.remove((Object)this.pods);
        if (pods != null) {
            this.pods = new PodsMetricSourceBuilder(pods);
            this._visitables.get((Object)"pods").add(this.pods);
        } else {
            this.pods = null;
            this._visitables.get((Object)"pods").remove((Object)this.pods);
        }
        return (A)((Object)this);
    }

    public boolean hasPods() {
        return this.pods != null;
    }

    public PodsNested<A> withNewPods() {
        return new PodsNested(null);
    }

    public PodsNested<A> withNewPodsLike(PodsMetricSource item) {
        return new PodsNested(item);
    }

    public PodsNested<A> editPods() {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(null));
    }

    public PodsNested<A> editOrNewPods() {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(new PodsMetricSourceBuilder().build()));
    }

    public PodsNested<A> editOrNewPodsLike(PodsMetricSource item) {
        return this.withNewPodsLike(Optional.ofNullable(this.buildPods()).orElse(item));
    }

    public ResourceMetricSource buildResource() {
        return this.resource != null ? this.resource.build() : null;
    }

    public A withResource(ResourceMetricSource resource) {
        this._visitables.remove((Object)this.resource);
        if (resource != null) {
            this.resource = new ResourceMetricSourceBuilder(resource);
            this._visitables.get((Object)"resource").add(this.resource);
        } else {
            this.resource = null;
            this._visitables.get((Object)"resource").remove((Object)this.resource);
        }
        return (A)((Object)this);
    }

    public boolean hasResource() {
        return this.resource != null;
    }

    public ResourceNested<A> withNewResource() {
        return new ResourceNested(null);
    }

    public ResourceNested<A> withNewResourceLike(ResourceMetricSource item) {
        return new ResourceNested(item);
    }

    public ResourceNested<A> editResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(null));
    }

    public ResourceNested<A> editOrNewResource() {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(new ResourceMetricSourceBuilder().build()));
    }

    public ResourceNested<A> editOrNewResourceLike(ResourceMetricSource item) {
        return this.withNewResourceLike(Optional.ofNullable(this.buildResource()).orElse(item));
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MetricSpecFluent that = (MetricSpecFluent)((Object)o);
        if (!Objects.equals((Object)this.containerResource, (Object)that.containerResource)) {
            return false;
        }
        if (!Objects.equals((Object)this.external, (Object)that.external)) {
            return false;
        }
        if (!Objects.equals((Object)this.object, (Object)that.object)) {
            return false;
        }
        if (!Objects.equals((Object)this.pods, (Object)that.pods)) {
            return false;
        }
        if (!Objects.equals((Object)this.resource, (Object)that.resource)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.containerResource, this.external, this.object, this.pods, this.resource, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.containerResource != null) {
            sb.append("containerResource:");
            sb.append((Object)((Object)this.containerResource) + ",");
        }
        if (this.external != null) {
            sb.append("external:");
            sb.append((Object)((Object)this.external) + ",");
        }
        if (this.object != null) {
            sb.append("object:");
            sb.append((Object)((Object)this.object) + ",");
        }
        if (this.pods != null) {
            sb.append("pods:");
            sb.append((Object)((Object)this.pods) + ",");
        }
        if (this.resource != null) {
            sb.append("resource:");
            sb.append((Object)((Object)this.resource) + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class ResourceNested<N>
    extends ResourceMetricSourceFluent<ResourceNested<N>>
    implements Nested<N> {
        ResourceMetricSourceBuilder builder;

        ResourceNested(ResourceMetricSource item) {
            this.builder = new ResourceMetricSourceBuilder(this, item);
        }

        public N and() {
            return (N)MetricSpecFluent.this.withResource(this.builder.build());
        }

        public N endResource() {
            return this.and();
        }
    }

    public class PodsNested<N>
    extends PodsMetricSourceFluent<PodsNested<N>>
    implements Nested<N> {
        PodsMetricSourceBuilder builder;

        PodsNested(PodsMetricSource item) {
            this.builder = new PodsMetricSourceBuilder(this, item);
        }

        public N and() {
            return (N)MetricSpecFluent.this.withPods(this.builder.build());
        }

        public N endPods() {
            return this.and();
        }
    }

    public class ObjectNested<N>
    extends ObjectMetricSourceFluent<ObjectNested<N>>
    implements Nested<N> {
        ObjectMetricSourceBuilder builder;

        ObjectNested(ObjectMetricSource item) {
            this.builder = new ObjectMetricSourceBuilder(this, item);
        }

        public N and() {
            return (N)MetricSpecFluent.this.withObject(this.builder.build());
        }

        public N endObject() {
            return this.and();
        }
    }

    public class ExternalNested<N>
    extends ExternalMetricSourceFluent<ExternalNested<N>>
    implements Nested<N> {
        ExternalMetricSourceBuilder builder;

        ExternalNested(ExternalMetricSource item) {
            this.builder = new ExternalMetricSourceBuilder(this, item);
        }

        public N and() {
            return (N)MetricSpecFluent.this.withExternal(this.builder.build());
        }

        public N endExternal() {
            return this.and();
        }
    }

    public class ContainerResourceNested<N>
    extends ContainerResourceMetricSourceFluent<ContainerResourceNested<N>>
    implements Nested<N> {
        ContainerResourceMetricSourceBuilder builder;

        ContainerResourceNested(ContainerResourceMetricSource item) {
            this.builder = new ContainerResourceMetricSourceBuilder(this, item);
        }

        public N and() {
            return (N)MetricSpecFluent.this.withContainerResource(this.builder.build());
        }

        public N endContainerResource() {
            return this.and();
        }
    }
}

