package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HPAScalingPolicyBuilder extends HPAScalingPolicyFluent<HPAScalingPolicyBuilder> implements VisitableBuilder<HPAScalingPolicy,HPAScalingPolicyBuilder>{
  public HPAScalingPolicyBuilder() {
    this(false);
  }
  public HPAScalingPolicyBuilder(Boolean validationEnabled) {
    this(new HPAScalingPolicy(), validationEnabled);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HPAScalingPolicy(), validationEnabled);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,HPAScalingPolicy instance) {
    this(fluent, instance, false);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicyFluent<?> fluent,HPAScalingPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HPAScalingPolicy());

    if (instance != null) {
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withPeriodSeconds(instance.getPeriodSeconds());
      fluent.withType(instance.getType());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicy instance) {
    this(instance,false);
  }
  public HPAScalingPolicyBuilder(HPAScalingPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HPAScalingPolicy());

    if (instance != null) {
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withPeriodSeconds(instance.getPeriodSeconds());
      this.withType(instance.getType());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HPAScalingPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public HPAScalingPolicy build() {
    HPAScalingPolicy buildable = new HPAScalingPolicy(fluent.getPeriodSeconds(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}