package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerStatusBuilder extends HorizontalPodAutoscalerStatusFluent<HorizontalPodAutoscalerStatusBuilder> implements VisitableBuilder<HorizontalPodAutoscalerStatus,HorizontalPodAutoscalerStatusBuilder>{
  public HorizontalPodAutoscalerStatusBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerStatusBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscalerStatus(), validationEnabled);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscalerStatus(), validationEnabled);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,HorizontalPodAutoscalerStatus instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatusFluent<?> fluent,HorizontalPodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerStatus());

    if (instance != null) {
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentMetrics(instance.getCurrentMetrics());
      fluent.withCurrentReplicas(instance.getCurrentReplicas());
      fluent.withDesiredReplicas(instance.getDesiredReplicas());
      fluent.withLastScaleTime(instance.getLastScaleTime());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withConditions(instance.getConditions());
      fluent.withCurrentMetrics(instance.getCurrentMetrics());
      fluent.withCurrentReplicas(instance.getCurrentReplicas());
      fluent.withDesiredReplicas(instance.getDesiredReplicas());
      fluent.withLastScaleTime(instance.getLastScaleTime());
      fluent.withObservedGeneration(instance.getObservedGeneration());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerStatusBuilder(HorizontalPodAutoscalerStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new HorizontalPodAutoscalerStatus());

    if (instance != null) {
      this.withConditions(instance.getConditions());
      this.withCurrentMetrics(instance.getCurrentMetrics());
      this.withCurrentReplicas(instance.getCurrentReplicas());
      this.withDesiredReplicas(instance.getDesiredReplicas());
      this.withLastScaleTime(instance.getLastScaleTime());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withConditions(instance.getConditions());
      this.withCurrentMetrics(instance.getCurrentMetrics());
      this.withCurrentReplicas(instance.getCurrentReplicas());
      this.withDesiredReplicas(instance.getDesiredReplicas());
      this.withLastScaleTime(instance.getLastScaleTime());
      this.withObservedGeneration(instance.getObservedGeneration());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  HorizontalPodAutoscalerStatusFluent<?> fluent;
  Boolean validationEnabled;
  public HorizontalPodAutoscalerStatus build() {
    HorizontalPodAutoscalerStatus buildable = new HorizontalPodAutoscalerStatus(fluent.buildConditions(),fluent.buildCurrentMetrics(),fluent.getCurrentReplicas(),fluent.getDesiredReplicas(),fluent.getLastScaleTime(),fluent.getObservedGeneration());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}