package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetricSourceBuilder extends ObjectMetricSourceFluent<ObjectMetricSourceBuilder> implements VisitableBuilder<ObjectMetricSource,ObjectMetricSourceBuilder>{
  public ObjectMetricSourceBuilder() {
    this(false);
  }
  public ObjectMetricSourceBuilder(Boolean validationEnabled) {
    this(new ObjectMetricSource(), validationEnabled);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectMetricSource(), validationEnabled);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,ObjectMetricSource instance) {
    this(fluent, instance, false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,ObjectMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ObjectMetricSource());

    if (instance != null) {
      fluent.withDescribedObject(instance.getDescribedObject());
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withDescribedObject(instance.getDescribedObject());
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetricSourceBuilder(ObjectMetricSource instance) {
    this(instance,false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ObjectMetricSource());

    if (instance != null) {
      this.withDescribedObject(instance.getDescribedObject());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withDescribedObject(instance.getDescribedObject());
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObjectMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectMetricSource build() {
    ObjectMetricSource buildable = new ObjectMetricSource(fluent.buildDescribedObject(),fluent.buildMetric(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}