package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetricSourceBuilder extends ObjectMetricSourceFluent<ObjectMetricSourceBuilder> implements VisitableBuilder<ObjectMetricSource,ObjectMetricSourceBuilder>{
  public ObjectMetricSourceBuilder() {
    this(false);
  }
  public ObjectMetricSourceBuilder(Boolean validationEnabled) {
    this(new ObjectMetricSource(), validationEnabled);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ObjectMetricSource(), validationEnabled);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,ObjectMetricSource instance) {
    this(fluent, instance, false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSourceFluent<?> fluent,ObjectMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ObjectMetricSource());

    if (instance != null) {
      fluent.withAverageValue(instance.getAverageValue());
      fluent.withMetricName(instance.getMetricName());
      fluent.withSelector(instance.getSelector());
      fluent.withTarget(instance.getTarget());
      fluent.withTargetValue(instance.getTargetValue());
      fluent.withAverageValue(instance.getAverageValue());
      fluent.withMetricName(instance.getMetricName());
      fluent.withSelector(instance.getSelector());
      fluent.withTarget(instance.getTarget());
      fluent.withTargetValue(instance.getTargetValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetricSourceBuilder(ObjectMetricSource instance) {
    this(instance,false);
  }
  public ObjectMetricSourceBuilder(ObjectMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ObjectMetricSource());

    if (instance != null) {
      this.withAverageValue(instance.getAverageValue());
      this.withMetricName(instance.getMetricName());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withTargetValue(instance.getTargetValue());
      this.withAverageValue(instance.getAverageValue());
      this.withMetricName(instance.getMetricName());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withTargetValue(instance.getTargetValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ObjectMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ObjectMetricSource build() {
    ObjectMetricSource buildable = new ObjectMetricSource(fluent.getAverageValue(),fluent.getMetricName(),fluent.buildSelector(),fluent.buildTarget(),fluent.getTargetValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}