package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MetricSpecFluent<A extends MetricSpecFluent<A>> extends BaseFluent<A>{
  public MetricSpecFluent() {
  }
  public MetricSpecFluent(MetricSpec instance) {
    instance = (instance != null ? instance : new MetricSpec());

    if (instance != null) {
      this.withContainerResource(instance.getContainerResource());
      this.withExternal(instance.getExternal());
      this.withObject(instance.getObject());
      this.withPods(instance.getPods());
      this.withResource(instance.getResource());
      this.withType(instance.getType());
      this.withContainerResource(instance.getContainerResource());
      this.withExternal(instance.getExternal());
      this.withObject(instance.getObject());
      this.withPods(instance.getPods());
      this.withResource(instance.getResource());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ContainerResourceMetricSourceBuilder containerResource;
  private ExternalMetricSourceBuilder external;
  private ObjectMetricSourceBuilder object;
  private PodsMetricSourceBuilder pods;
  private ResourceMetricSourceBuilder resource;
  private String type;
  private Map<String,Object> additionalProperties;
  public ContainerResourceMetricSource buildContainerResource() {
    return this.containerResource!=null ?this.containerResource.build():null;
  }
  public A withContainerResource(ContainerResourceMetricSource containerResource) {
    _visitables.get("containerResource").remove(this.containerResource);
    if (containerResource!=null){ this.containerResource= new ContainerResourceMetricSourceBuilder(containerResource); _visitables.get("containerResource").add(this.containerResource);} else { this.containerResource = null; _visitables.get("containerResource").remove(this.containerResource); } return (A) this;
  }
  public boolean hasContainerResource() {
    return this.containerResource != null;
  }
  public ContainerResourceNested<A> withNewContainerResource() {
    return new ContainerResourceNested(null);
  }
  public ContainerResourceNested<A> withNewContainerResourceLike(ContainerResourceMetricSource item) {
    return new ContainerResourceNested(item);
  }
  public ContainerResourceNested<A> editContainerResource() {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(null));
  }
  public ContainerResourceNested<A> editOrNewContainerResource() {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(new ContainerResourceMetricSourceBuilder().build()));
  }
  public ContainerResourceNested<A> editOrNewContainerResourceLike(ContainerResourceMetricSource item) {
    return withNewContainerResourceLike(java.util.Optional.ofNullable(buildContainerResource()).orElse(item));
  }
  public ExternalMetricSource buildExternal() {
    return this.external!=null ?this.external.build():null;
  }
  public A withExternal(ExternalMetricSource external) {
    _visitables.get("external").remove(this.external);
    if (external!=null){ this.external= new ExternalMetricSourceBuilder(external); _visitables.get("external").add(this.external);} else { this.external = null; _visitables.get("external").remove(this.external); } return (A) this;
  }
  public boolean hasExternal() {
    return this.external != null;
  }
  public ExternalNested<A> withNewExternal() {
    return new ExternalNested(null);
  }
  public ExternalNested<A> withNewExternalLike(ExternalMetricSource item) {
    return new ExternalNested(item);
  }
  public ExternalNested<A> editExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(null));
  }
  public ExternalNested<A> editOrNewExternal() {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(new ExternalMetricSourceBuilder().build()));
  }
  public ExternalNested<A> editOrNewExternalLike(ExternalMetricSource item) {
    return withNewExternalLike(java.util.Optional.ofNullable(buildExternal()).orElse(item));
  }
  public ObjectMetricSource buildObject() {
    return this.object!=null ?this.object.build():null;
  }
  public A withObject(ObjectMetricSource object) {
    _visitables.get("object").remove(this.object);
    if (object!=null){ this.object= new ObjectMetricSourceBuilder(object); _visitables.get("object").add(this.object);} else { this.object = null; _visitables.get("object").remove(this.object); } return (A) this;
  }
  public boolean hasObject() {
    return this.object != null;
  }
  public ObjectNested<A> withNewObject() {
    return new ObjectNested(null);
  }
  public ObjectNested<A> withNewObjectLike(ObjectMetricSource item) {
    return new ObjectNested(item);
  }
  public ObjectNested<A> editObject() {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(null));
  }
  public ObjectNested<A> editOrNewObject() {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(new ObjectMetricSourceBuilder().build()));
  }
  public ObjectNested<A> editOrNewObjectLike(ObjectMetricSource item) {
    return withNewObjectLike(java.util.Optional.ofNullable(buildObject()).orElse(item));
  }
  public PodsMetricSource buildPods() {
    return this.pods!=null ?this.pods.build():null;
  }
  public A withPods(PodsMetricSource pods) {
    _visitables.get("pods").remove(this.pods);
    if (pods!=null){ this.pods= new PodsMetricSourceBuilder(pods); _visitables.get("pods").add(this.pods);} else { this.pods = null; _visitables.get("pods").remove(this.pods); } return (A) this;
  }
  public boolean hasPods() {
    return this.pods != null;
  }
  public PodsNested<A> withNewPods() {
    return new PodsNested(null);
  }
  public PodsNested<A> withNewPodsLike(PodsMetricSource item) {
    return new PodsNested(item);
  }
  public PodsNested<A> editPods() {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(null));
  }
  public PodsNested<A> editOrNewPods() {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(new PodsMetricSourceBuilder().build()));
  }
  public PodsNested<A> editOrNewPodsLike(PodsMetricSource item) {
    return withNewPodsLike(java.util.Optional.ofNullable(buildPods()).orElse(item));
  }
  public ResourceMetricSource buildResource() {
    return this.resource!=null ?this.resource.build():null;
  }
  public A withResource(ResourceMetricSource resource) {
    _visitables.get("resource").remove(this.resource);
    if (resource!=null){ this.resource= new ResourceMetricSourceBuilder(resource); _visitables.get("resource").add(this.resource);} else { this.resource = null; _visitables.get("resource").remove(this.resource); } return (A) this;
  }
  public boolean hasResource() {
    return this.resource != null;
  }
  public ResourceNested<A> withNewResource() {
    return new ResourceNested(null);
  }
  public ResourceNested<A> withNewResourceLike(ResourceMetricSource item) {
    return new ResourceNested(item);
  }
  public ResourceNested<A> editResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(null));
  }
  public ResourceNested<A> editOrNewResource() {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(new ResourceMetricSourceBuilder().build()));
  }
  public ResourceNested<A> editOrNewResourceLike(ResourceMetricSource item) {
    return withNewResourceLike(java.util.Optional.ofNullable(buildResource()).orElse(item));
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetricSpecFluent that = (MetricSpecFluent) o;
    if (!java.util.Objects.equals(containerResource, that.containerResource)) return false;

    if (!java.util.Objects.equals(external, that.external)) return false;

    if (!java.util.Objects.equals(object, that.object)) return false;

    if (!java.util.Objects.equals(pods, that.pods)) return false;

    if (!java.util.Objects.equals(resource, that.resource)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerResource,  external,  object,  pods,  resource,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerResource != null) { sb.append("containerResource:"); sb.append(containerResource + ","); }
    if (external != null) { sb.append("external:"); sb.append(external + ","); }
    if (object != null) { sb.append("object:"); sb.append(object + ","); }
    if (pods != null) { sb.append("pods:"); sb.append(pods + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ContainerResourceNested<N> extends ContainerResourceMetricSourceFluent<ContainerResourceNested<N>> implements Nested<N>{
    ContainerResourceNested(ContainerResourceMetricSource item) {
      this.builder = new ContainerResourceMetricSourceBuilder(this, item);
    }
    ContainerResourceMetricSourceBuilder builder;
    public N and() {
      return (N) MetricSpecFluent.this.withContainerResource(builder.build());
    }
    public N endContainerResource() {
      return and();
    }
    
  }
  public class ExternalNested<N> extends ExternalMetricSourceFluent<ExternalNested<N>> implements Nested<N>{
    ExternalNested(ExternalMetricSource item) {
      this.builder = new ExternalMetricSourceBuilder(this, item);
    }
    ExternalMetricSourceBuilder builder;
    public N and() {
      return (N) MetricSpecFluent.this.withExternal(builder.build());
    }
    public N endExternal() {
      return and();
    }
    
  }
  public class ObjectNested<N> extends ObjectMetricSourceFluent<ObjectNested<N>> implements Nested<N>{
    ObjectNested(ObjectMetricSource item) {
      this.builder = new ObjectMetricSourceBuilder(this, item);
    }
    ObjectMetricSourceBuilder builder;
    public N and() {
      return (N) MetricSpecFluent.this.withObject(builder.build());
    }
    public N endObject() {
      return and();
    }
    
  }
  public class PodsNested<N> extends PodsMetricSourceFluent<PodsNested<N>> implements Nested<N>{
    PodsNested(PodsMetricSource item) {
      this.builder = new PodsMetricSourceBuilder(this, item);
    }
    PodsMetricSourceBuilder builder;
    public N and() {
      return (N) MetricSpecFluent.this.withPods(builder.build());
    }
    public N endPods() {
      return and();
    }
    
  }
  public class ResourceNested<N> extends ResourceMetricSourceFluent<ResourceNested<N>> implements Nested<N>{
    ResourceNested(ResourceMetricSource item) {
      this.builder = new ResourceMetricSourceBuilder(this, item);
    }
    ResourceMetricSourceBuilder builder;
    public N and() {
      return (N) MetricSpecFluent.this.withResource(builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  
}