package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricSourceBuilder extends ExternalMetricSourceFluent<ExternalMetricSourceBuilder> implements VisitableBuilder<ExternalMetricSource,ExternalMetricSourceBuilder>{
  public ExternalMetricSourceBuilder() {
    this(false);
  }
  public ExternalMetricSourceBuilder(Boolean validationEnabled) {
    this(new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ExternalMetricSource());

    if (instance != null) {
      fluent.withMetricName(instance.getMetricName());
      fluent.withMetricSelector(instance.getMetricSelector());
      fluent.withTargetAverageValue(instance.getTargetAverageValue());
      fluent.withTargetValue(instance.getTargetValue());
      fluent.withMetricName(instance.getMetricName());
      fluent.withMetricSelector(instance.getMetricSelector());
      fluent.withTargetAverageValue(instance.getTargetAverageValue());
      fluent.withTargetValue(instance.getTargetValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance) {
    this(instance,false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ExternalMetricSource());

    if (instance != null) {
      this.withMetricName(instance.getMetricName());
      this.withMetricSelector(instance.getMetricSelector());
      this.withTargetAverageValue(instance.getTargetAverageValue());
      this.withTargetValue(instance.getTargetValue());
      this.withMetricName(instance.getMetricName());
      this.withMetricSelector(instance.getMetricSelector());
      this.withTargetAverageValue(instance.getTargetAverageValue());
      this.withTargetValue(instance.getTargetValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalMetricSource build() {
    ExternalMetricSource buildable = new ExternalMetricSource(fluent.getMetricName(),fluent.buildMetricSelector(),fluent.getTargetAverageValue(),fluent.getTargetValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}