package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ContainerResourceMetricSourceBuilder extends ContainerResourceMetricSourceFluent<ContainerResourceMetricSourceBuilder> implements VisitableBuilder<ContainerResourceMetricSource,ContainerResourceMetricSourceBuilder>{
  public ContainerResourceMetricSourceBuilder() {
    this(false);
  }
  public ContainerResourceMetricSourceBuilder(Boolean validationEnabled) {
    this(new ContainerResourceMetricSource(), validationEnabled);
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ContainerResourceMetricSource(), validationEnabled);
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,ContainerResourceMetricSource instance) {
    this(fluent, instance, false);
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSourceFluent<?> fluent,ContainerResourceMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ContainerResourceMetricSource());

    if (instance != null) {
      fluent.withContainer(instance.getContainer());
      fluent.withName(instance.getName());
      fluent.withTarget(instance.getTarget());
      fluent.withContainer(instance.getContainer());
      fluent.withName(instance.getName());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance) {
    this(instance,false);
  }
  public ContainerResourceMetricSourceBuilder(ContainerResourceMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ContainerResourceMetricSource());

    if (instance != null) {
      this.withContainer(instance.getContainer());
      this.withName(instance.getName());
      this.withTarget(instance.getTarget());
      this.withContainer(instance.getContainer());
      this.withName(instance.getName());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ContainerResourceMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ContainerResourceMetricSource build() {
    ContainerResourceMetricSource buildable = new ContainerResourceMetricSource(fluent.getContainer(),fluent.getName(),fluent.buildTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}