package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PodsMetricStatusBuilder extends PodsMetricStatusFluentImpl<PodsMetricStatusBuilder> implements VisitableBuilder<PodsMetricStatus,PodsMetricStatusBuilder>{
  public PodsMetricStatusBuilder() {
    this(false);
  }
  public PodsMetricStatusBuilder(Boolean validationEnabled) {
    this(new PodsMetricStatus(), validationEnabled);
  }
  public PodsMetricStatusBuilder(PodsMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public PodsMetricStatusBuilder(PodsMetricStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new PodsMetricStatus(), validationEnabled);
  }
  public PodsMetricStatusBuilder(PodsMetricStatusFluent<?> fluent,PodsMetricStatus instance) {
    this(fluent, instance, false);
  }
  public PodsMetricStatusBuilder(PodsMetricStatusFluent<?> fluent,PodsMetricStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withCurrentAverageValue(instance.getCurrentAverageValue());
      fluent.withMetricName(instance.getMetricName());
      fluent.withSelector(instance.getSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public PodsMetricStatusBuilder(PodsMetricStatus instance) {
    this(instance,false);
  }
  public PodsMetricStatusBuilder(PodsMetricStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withCurrentAverageValue(instance.getCurrentAverageValue());
      this.withMetricName(instance.getMetricName());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  PodsMetricStatusFluent<?> fluent;
  Boolean validationEnabled;
  public PodsMetricStatus build() {
    PodsMetricStatus buildable = new PodsMetricStatus(fluent.getCurrentAverageValue(),fluent.getMetricName(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}