package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ObjectMetricStatusFluentImpl<A extends ObjectMetricStatusFluent<A>> extends BaseFluent<A> implements ObjectMetricStatusFluent<A>{
  public ObjectMetricStatusFluentImpl() {
  }
  public ObjectMetricStatusFluentImpl(ObjectMetricStatus instance) {
    if (instance != null) {
      this.withAverageValue(instance.getAverageValue());
      this.withCurrentValue(instance.getCurrentValue());
      this.withMetricName(instance.getMetricName());
      this.withSelector(instance.getSelector());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private Quantity averageValue;
  private Quantity currentValue;
  private String metricName;
  private LabelSelectorBuilder selector;
  private CrossVersionObjectReferenceBuilder target;
  private Map<String,Object> additionalProperties;
  public Quantity getAverageValue() {
    return this.averageValue;
  }
  public A withAverageValue(Quantity averageValue) {
    this.averageValue=averageValue; return (A) this;
  }
  public Boolean hasAverageValue() {
    return this.averageValue != null;
  }
  public A withNewAverageValue(String amount,String format) {
    return (A)withAverageValue(new Quantity(amount, format));
  }
  public A withNewAverageValue(String amount) {
    return (A)withAverageValue(new Quantity(amount));
  }
  public Quantity getCurrentValue() {
    return this.currentValue;
  }
  public A withCurrentValue(Quantity currentValue) {
    this.currentValue=currentValue; return (A) this;
  }
  public Boolean hasCurrentValue() {
    return this.currentValue != null;
  }
  public A withNewCurrentValue(String amount,String format) {
    return (A)withCurrentValue(new Quantity(amount, format));
  }
  public A withNewCurrentValue(String amount) {
    return (A)withCurrentValue(new Quantity(amount));
  }
  public String getMetricName() {
    return this.metricName;
  }
  public A withMetricName(String metricName) {
    this.metricName=metricName; return (A) this;
  }
  public Boolean hasMetricName() {
    return this.metricName != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public LabelSelector buildSelector() {
    return this.selector!=null ?this.selector.build():null;
  }
  public A withSelector(LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} else { this.selector = null; _visitables.get("selector").remove(this.selector); } return (A) this;
  }
  public Boolean hasSelector() {
    return this.selector != null;
  }
  public ObjectMetricStatusFluentImpl.SelectorNested<A> withNewSelector() {
    return new ObjectMetricStatusFluentImpl.SelectorNestedImpl();
  }
  public ObjectMetricStatusFluentImpl.SelectorNested<A> withNewSelectorLike(LabelSelector item) {
    return new ObjectMetricStatusFluentImpl.SelectorNestedImpl(item);
  }
  public ObjectMetricStatusFluentImpl.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public ObjectMetricStatusFluentImpl.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new LabelSelectorBuilder().build());
  }
  public ObjectMetricStatusFluentImpl.SelectorNested<A> editOrNewSelectorLike(LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public CrossVersionObjectReference buildTarget() {
    return this.target!=null ?this.target.build():null;
  }
  public A withTarget(CrossVersionObjectReference target) {
    _visitables.get("target").remove(this.target);
    if (target!=null){ this.target= new CrossVersionObjectReferenceBuilder(target); _visitables.get("target").add(this.target);} else { this.target = null; _visitables.get("target").remove(this.target); } return (A) this;
  }
  public Boolean hasTarget() {
    return this.target != null;
  }
  public A withNewTarget(String apiVersion,String kind,String name) {
    return (A)withTarget(new CrossVersionObjectReference(apiVersion, kind, name));
  }
  public ObjectMetricStatusFluentImpl.TargetNested<A> withNewTarget() {
    return new ObjectMetricStatusFluentImpl.TargetNestedImpl();
  }
  public ObjectMetricStatusFluentImpl.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item) {
    return new ObjectMetricStatusFluentImpl.TargetNestedImpl(item);
  }
  public ObjectMetricStatusFluentImpl.TargetNested<A> editTarget() {
    return withNewTargetLike(getTarget());
  }
  public ObjectMetricStatusFluentImpl.TargetNested<A> editOrNewTarget() {
    return withNewTargetLike(getTarget() != null ? getTarget(): new CrossVersionObjectReferenceBuilder().build());
  }
  public ObjectMetricStatusFluentImpl.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item) {
    return withNewTargetLike(getTarget() != null ? getTarget(): item);
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ObjectMetricStatusFluentImpl that = (ObjectMetricStatusFluentImpl) o;
    if (!java.util.Objects.equals(averageValue, that.averageValue)) return false;

    if (!java.util.Objects.equals(currentValue, that.currentValue)) return false;

    if (!java.util.Objects.equals(metricName, that.metricName)) return false;

    if (!java.util.Objects.equals(selector, that.selector)) return false;

    if (!java.util.Objects.equals(target, that.target)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(averageValue,  currentValue,  metricName,  selector,  target,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (averageValue != null) { sb.append("averageValue:"); sb.append(averageValue + ","); }
    if (currentValue != null) { sb.append("currentValue:"); sb.append(currentValue + ","); }
    if (metricName != null) { sb.append("metricName:"); sb.append(metricName + ","); }
    if (selector != null) { sb.append("selector:"); sb.append(selector + ","); }
    if (target != null) { sb.append("target:"); sb.append(target + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class SelectorNestedImpl<N> extends LabelSelectorFluentImpl<ObjectMetricStatusFluentImpl.SelectorNested<N>> implements ObjectMetricStatusFluentImpl.SelectorNested<N>,Nested<N>{
    SelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  class TargetNestedImpl<N> extends CrossVersionObjectReferenceFluentImpl<ObjectMetricStatusFluentImpl.TargetNested<N>> implements ObjectMetricStatusFluentImpl.TargetNested<N>,Nested<N>{
    TargetNestedImpl(CrossVersionObjectReference item) {
      this.builder = new CrossVersionObjectReferenceBuilder(this, item);
    }
    TargetNestedImpl() {
      this.builder = new CrossVersionObjectReferenceBuilder(this);
    }
    CrossVersionObjectReferenceBuilder builder;
    public N and() {
      return (N) ObjectMetricStatusFluentImpl.this.withTarget(builder.build());
    }
    public N endTarget() {
      return and();
    }
    
  }
  
}