package io.fabric8.kubernetes.api.model.autoscaling.v2beta1;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
public interface ObjectMetricStatusFluent<A extends ObjectMetricStatusFluent<A>> extends Fluent<A>{
  public Quantity getAverageValue();
  public A withAverageValue(Quantity averageValue);
  public Boolean hasAverageValue();
  public A withNewAverageValue(String amount,String format);
  public A withNewAverageValue(String amount);
  public Quantity getCurrentValue();
  public A withCurrentValue(Quantity currentValue);
  public Boolean hasCurrentValue();
  public A withNewCurrentValue(String amount,String format);
  public A withNewCurrentValue(String amount);
  public String getMetricName();
  public A withMetricName(String metricName);
  public Boolean hasMetricName();
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getSelector();
  public LabelSelector buildSelector();
  public A withSelector(LabelSelector selector);
  public Boolean hasSelector();
  public ObjectMetricStatusFluent.SelectorNested<A> withNewSelector();
  public ObjectMetricStatusFluent.SelectorNested<A> withNewSelectorLike(LabelSelector item);
  public ObjectMetricStatusFluent.SelectorNested<A> editSelector();
  public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelector();
  public ObjectMetricStatusFluent.SelectorNested<A> editOrNewSelectorLike(LabelSelector item);
  
  /**
   * This method has been deprecated, please use method buildTarget instead.
   * @return The buildable object.
   */
  @Deprecated
  public CrossVersionObjectReference getTarget();
  public CrossVersionObjectReference buildTarget();
  public A withTarget(CrossVersionObjectReference target);
  public Boolean hasTarget();
  public A withNewTarget(String apiVersion,String kind,String name);
  public ObjectMetricStatusFluent.TargetNested<A> withNewTarget();
  public ObjectMetricStatusFluent.TargetNested<A> withNewTargetLike(CrossVersionObjectReference item);
  public ObjectMetricStatusFluent.TargetNested<A> editTarget();
  public ObjectMetricStatusFluent.TargetNested<A> editOrNewTarget();
  public ObjectMetricStatusFluent.TargetNested<A> editOrNewTargetLike(CrossVersionObjectReference item);
  public A addToAdditionalProperties(String key,Object value);
  public A addToAdditionalProperties(Map<String,Object> map);
  public A removeFromAdditionalProperties(String key);
  public A removeFromAdditionalProperties(Map<String,Object> map);
  public Map<String,Object> getAdditionalProperties();
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties);
  public Boolean hasAdditionalProperties();
  public interface SelectorNested<N> extends Nested<N>,LabelSelectorFluent<ObjectMetricStatusFluent.SelectorNested<N>>{
    public N and();
    public N endSelector();
    
  }
  public interface TargetNested<N> extends Nested<N>,CrossVersionObjectReferenceFluent<ObjectMetricStatusFluent.TargetNested<N>>{
    public N and();
    public N endTarget();
    
  }
  
}