package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricValueStatusBuilder extends MetricValueStatusFluentImpl<MetricValueStatusBuilder> implements VisitableBuilder<MetricValueStatus,MetricValueStatusBuilder>{
  public MetricValueStatusBuilder() {
    this(false);
  }
  public MetricValueStatusBuilder(Boolean validationEnabled) {
    this(new MetricValueStatus(), validationEnabled);
  }
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MetricValueStatus(), validationEnabled);
  }
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,MetricValueStatus instance) {
    this(fluent, instance, false);
  }
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent,MetricValueStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAverageUtilization(instance.getAverageUtilization());
      fluent.withAverageValue(instance.getAverageValue());
      fluent.withValue(instance.getValue());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MetricValueStatusBuilder(MetricValueStatus instance) {
    this(instance,false);
  }
  public MetricValueStatusBuilder(MetricValueStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAverageUtilization(instance.getAverageUtilization());
      this.withAverageValue(instance.getAverageValue());
      this.withValue(instance.getValue());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MetricValueStatusFluent<?> fluent;
  Boolean validationEnabled;
  public MetricValueStatus build() {
    MetricValueStatus buildable = new MetricValueStatus(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}