package io.fabric8.kubernetes.api.model.autoscaling.v2;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MetricStatusFluentImpl<A extends MetricStatusFluent<A>> extends BaseFluent<A> implements MetricStatusFluent<A>{
  public MetricStatusFluentImpl() {
  }
  public MetricStatusFluentImpl(MetricStatus instance) {
    if (instance != null) {
      this.withContainerResource(instance.getContainerResource());
      this.withExternal(instance.getExternal());
      this.withObject(instance.getObject());
      this.withPods(instance.getPods());
      this.withResource(instance.getResource());
      this.withType(instance.getType());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private ContainerResourceMetricStatusBuilder containerResource;
  private ExternalMetricStatusBuilder external;
  private ObjectMetricStatusBuilder object;
  private PodsMetricStatusBuilder pods;
  private ResourceMetricStatusBuilder resource;
  private String type;
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildContainerResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public ContainerResourceMetricStatus getContainerResource() {
    return this.containerResource!=null ?this.containerResource.build():null;
  }
  public ContainerResourceMetricStatus buildContainerResource() {
    return this.containerResource!=null ?this.containerResource.build():null;
  }
  public A withContainerResource(ContainerResourceMetricStatus containerResource) {
    _visitables.get("containerResource").remove(this.containerResource);
    if (containerResource!=null){ this.containerResource= new ContainerResourceMetricStatusBuilder(containerResource); _visitables.get("containerResource").add(this.containerResource);} else { this.containerResource = null; _visitables.get("containerResource").remove(this.containerResource); } return (A) this;
  }
  public Boolean hasContainerResource() {
    return this.containerResource != null;
  }
  public MetricStatusFluentImpl.ContainerResourceNested<A> withNewContainerResource() {
    return new MetricStatusFluentImpl.ContainerResourceNestedImpl();
  }
  public MetricStatusFluentImpl.ContainerResourceNested<A> withNewContainerResourceLike(ContainerResourceMetricStatus item) {
    return new MetricStatusFluentImpl.ContainerResourceNestedImpl(item);
  }
  public MetricStatusFluentImpl.ContainerResourceNested<A> editContainerResource() {
    return withNewContainerResourceLike(getContainerResource());
  }
  public MetricStatusFluentImpl.ContainerResourceNested<A> editOrNewContainerResource() {
    return withNewContainerResourceLike(getContainerResource() != null ? getContainerResource(): new ContainerResourceMetricStatusBuilder().build());
  }
  public MetricStatusFluentImpl.ContainerResourceNested<A> editOrNewContainerResourceLike(ContainerResourceMetricStatus item) {
    return withNewContainerResourceLike(getContainerResource() != null ? getContainerResource(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildExternal instead.
   * @return The buildable object.
   */
  @Deprecated
  public ExternalMetricStatus getExternal() {
    return this.external!=null ?this.external.build():null;
  }
  public ExternalMetricStatus buildExternal() {
    return this.external!=null ?this.external.build():null;
  }
  public A withExternal(ExternalMetricStatus external) {
    _visitables.get("external").remove(this.external);
    if (external!=null){ this.external= new ExternalMetricStatusBuilder(external); _visitables.get("external").add(this.external);} else { this.external = null; _visitables.get("external").remove(this.external); } return (A) this;
  }
  public Boolean hasExternal() {
    return this.external != null;
  }
  public MetricStatusFluentImpl.ExternalNested<A> withNewExternal() {
    return new MetricStatusFluentImpl.ExternalNestedImpl();
  }
  public MetricStatusFluentImpl.ExternalNested<A> withNewExternalLike(ExternalMetricStatus item) {
    return new MetricStatusFluentImpl.ExternalNestedImpl(item);
  }
  public MetricStatusFluentImpl.ExternalNested<A> editExternal() {
    return withNewExternalLike(getExternal());
  }
  public MetricStatusFluentImpl.ExternalNested<A> editOrNewExternal() {
    return withNewExternalLike(getExternal() != null ? getExternal(): new ExternalMetricStatusBuilder().build());
  }
  public MetricStatusFluentImpl.ExternalNested<A> editOrNewExternalLike(ExternalMetricStatus item) {
    return withNewExternalLike(getExternal() != null ? getExternal(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObject instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMetricStatus getObject() {
    return this.object!=null ?this.object.build():null;
  }
  public ObjectMetricStatus buildObject() {
    return this.object!=null ?this.object.build():null;
  }
  public A withObject(ObjectMetricStatus object) {
    _visitables.get("object").remove(this.object);
    if (object!=null){ this.object= new ObjectMetricStatusBuilder(object); _visitables.get("object").add(this.object);} else { this.object = null; _visitables.get("object").remove(this.object); } return (A) this;
  }
  public Boolean hasObject() {
    return this.object != null;
  }
  public MetricStatusFluentImpl.ObjectNested<A> withNewObject() {
    return new MetricStatusFluentImpl.ObjectNestedImpl();
  }
  public MetricStatusFluentImpl.ObjectNested<A> withNewObjectLike(ObjectMetricStatus item) {
    return new MetricStatusFluentImpl.ObjectNestedImpl(item);
  }
  public MetricStatusFluentImpl.ObjectNested<A> editObject() {
    return withNewObjectLike(getObject());
  }
  public MetricStatusFluentImpl.ObjectNested<A> editOrNewObject() {
    return withNewObjectLike(getObject() != null ? getObject(): new ObjectMetricStatusBuilder().build());
  }
  public MetricStatusFluentImpl.ObjectNested<A> editOrNewObjectLike(ObjectMetricStatus item) {
    return withNewObjectLike(getObject() != null ? getObject(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildPods instead.
   * @return The buildable object.
   */
  @Deprecated
  public PodsMetricStatus getPods() {
    return this.pods!=null ?this.pods.build():null;
  }
  public PodsMetricStatus buildPods() {
    return this.pods!=null ?this.pods.build():null;
  }
  public A withPods(PodsMetricStatus pods) {
    _visitables.get("pods").remove(this.pods);
    if (pods!=null){ this.pods= new PodsMetricStatusBuilder(pods); _visitables.get("pods").add(this.pods);} else { this.pods = null; _visitables.get("pods").remove(this.pods); } return (A) this;
  }
  public Boolean hasPods() {
    return this.pods != null;
  }
  public MetricStatusFluentImpl.PodsNested<A> withNewPods() {
    return new MetricStatusFluentImpl.PodsNestedImpl();
  }
  public MetricStatusFluentImpl.PodsNested<A> withNewPodsLike(PodsMetricStatus item) {
    return new MetricStatusFluentImpl.PodsNestedImpl(item);
  }
  public MetricStatusFluentImpl.PodsNested<A> editPods() {
    return withNewPodsLike(getPods());
  }
  public MetricStatusFluentImpl.PodsNested<A> editOrNewPods() {
    return withNewPodsLike(getPods() != null ? getPods(): new PodsMetricStatusBuilder().build());
  }
  public MetricStatusFluentImpl.PodsNested<A> editOrNewPodsLike(PodsMetricStatus item) {
    return withNewPodsLike(getPods() != null ? getPods(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildResource instead.
   * @return The buildable object.
   */
  @Deprecated
  public ResourceMetricStatus getResource() {
    return this.resource!=null ?this.resource.build():null;
  }
  public ResourceMetricStatus buildResource() {
    return this.resource!=null ?this.resource.build():null;
  }
  public A withResource(ResourceMetricStatus resource) {
    _visitables.get("resource").remove(this.resource);
    if (resource!=null){ this.resource= new ResourceMetricStatusBuilder(resource); _visitables.get("resource").add(this.resource);} else { this.resource = null; _visitables.get("resource").remove(this.resource); } return (A) this;
  }
  public Boolean hasResource() {
    return this.resource != null;
  }
  public MetricStatusFluentImpl.ResourceNested<A> withNewResource() {
    return new MetricStatusFluentImpl.ResourceNestedImpl();
  }
  public MetricStatusFluentImpl.ResourceNested<A> withNewResourceLike(ResourceMetricStatus item) {
    return new MetricStatusFluentImpl.ResourceNestedImpl(item);
  }
  public MetricStatusFluentImpl.ResourceNested<A> editResource() {
    return withNewResourceLike(getResource());
  }
  public MetricStatusFluentImpl.ResourceNested<A> editOrNewResource() {
    return withNewResourceLike(getResource() != null ? getResource(): new ResourceMetricStatusBuilder().build());
  }
  public MetricStatusFluentImpl.ResourceNested<A> editOrNewResourceLike(ResourceMetricStatus item) {
    return withNewResourceLike(getResource() != null ? getResource(): item);
  }
  public String getType() {
    return this.type;
  }
  public A withType(String type) {
    this.type=type; return (A) this;
  }
  public Boolean hasType() {
    return this.type != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MetricStatusFluentImpl that = (MetricStatusFluentImpl) o;
    if (!java.util.Objects.equals(containerResource, that.containerResource)) return false;

    if (!java.util.Objects.equals(external, that.external)) return false;

    if (!java.util.Objects.equals(object, that.object)) return false;

    if (!java.util.Objects.equals(pods, that.pods)) return false;

    if (!java.util.Objects.equals(resource, that.resource)) return false;

    if (!java.util.Objects.equals(type, that.type)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(containerResource,  external,  object,  pods,  resource,  type,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (containerResource != null) { sb.append("containerResource:"); sb.append(containerResource + ","); }
    if (external != null) { sb.append("external:"); sb.append(external + ","); }
    if (object != null) { sb.append("object:"); sb.append(object + ","); }
    if (pods != null) { sb.append("pods:"); sb.append(pods + ","); }
    if (resource != null) { sb.append("resource:"); sb.append(resource + ","); }
    if (type != null) { sb.append("type:"); sb.append(type + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ContainerResourceNestedImpl<N> extends ContainerResourceMetricStatusFluentImpl<MetricStatusFluentImpl.ContainerResourceNested<N>> implements MetricStatusFluentImpl.ContainerResourceNested<N>,Nested<N>{
    ContainerResourceNestedImpl(ContainerResourceMetricStatus item) {
      this.builder = new ContainerResourceMetricStatusBuilder(this, item);
    }
    ContainerResourceNestedImpl() {
      this.builder = new ContainerResourceMetricStatusBuilder(this);
    }
    ContainerResourceMetricStatusBuilder builder;
    public N and() {
      return (N) MetricStatusFluentImpl.this.withContainerResource(builder.build());
    }
    public N endContainerResource() {
      return and();
    }
    
  }
  class ExternalNestedImpl<N> extends ExternalMetricStatusFluentImpl<MetricStatusFluentImpl.ExternalNested<N>> implements MetricStatusFluentImpl.ExternalNested<N>,Nested<N>{
    ExternalNestedImpl(ExternalMetricStatus item) {
      this.builder = new ExternalMetricStatusBuilder(this, item);
    }
    ExternalNestedImpl() {
      this.builder = new ExternalMetricStatusBuilder(this);
    }
    ExternalMetricStatusBuilder builder;
    public N and() {
      return (N) MetricStatusFluentImpl.this.withExternal(builder.build());
    }
    public N endExternal() {
      return and();
    }
    
  }
  class ObjectNestedImpl<N> extends ObjectMetricStatusFluentImpl<MetricStatusFluentImpl.ObjectNested<N>> implements MetricStatusFluentImpl.ObjectNested<N>,Nested<N>{
    ObjectNestedImpl(ObjectMetricStatus item) {
      this.builder = new ObjectMetricStatusBuilder(this, item);
    }
    ObjectNestedImpl() {
      this.builder = new ObjectMetricStatusBuilder(this);
    }
    ObjectMetricStatusBuilder builder;
    public N and() {
      return (N) MetricStatusFluentImpl.this.withObject(builder.build());
    }
    public N endObject() {
      return and();
    }
    
  }
  class PodsNestedImpl<N> extends PodsMetricStatusFluentImpl<MetricStatusFluentImpl.PodsNested<N>> implements MetricStatusFluentImpl.PodsNested<N>,Nested<N>{
    PodsNestedImpl(PodsMetricStatus item) {
      this.builder = new PodsMetricStatusBuilder(this, item);
    }
    PodsNestedImpl() {
      this.builder = new PodsMetricStatusBuilder(this);
    }
    PodsMetricStatusBuilder builder;
    public N and() {
      return (N) MetricStatusFluentImpl.this.withPods(builder.build());
    }
    public N endPods() {
      return and();
    }
    
  }
  class ResourceNestedImpl<N> extends ResourceMetricStatusFluentImpl<MetricStatusFluentImpl.ResourceNested<N>> implements MetricStatusFluentImpl.ResourceNested<N>,Nested<N>{
    ResourceNestedImpl(ResourceMetricStatus item) {
      this.builder = new ResourceMetricStatusBuilder(this, item);
    }
    ResourceNestedImpl() {
      this.builder = new ResourceMetricStatusBuilder(this);
    }
    ResourceMetricStatusBuilder builder;
    public N and() {
      return (N) MetricStatusFluentImpl.this.withResource(builder.build());
    }
    public N endResource() {
      return and();
    }
    
  }
  
}