package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ExternalMetricSourceBuilder extends ExternalMetricSourceFluentImpl<ExternalMetricSourceBuilder> implements VisitableBuilder<ExternalMetricSource,ExternalMetricSourceBuilder>{
  public ExternalMetricSourceBuilder() {
    this(false);
  }
  public ExternalMetricSourceBuilder(Boolean validationEnabled) {
    this(new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ExternalMetricSource(), validationEnabled);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance) {
    this(fluent, instance, false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSourceFluent<?> fluent,ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withMetric(instance.getMetric());
      fluent.withTarget(instance.getTarget());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance) {
    this(instance,false);
  }
  public ExternalMetricSourceBuilder(ExternalMetricSource instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withMetric(instance.getMetric());
      this.withTarget(instance.getTarget());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ExternalMetricSourceFluent<?> fluent;
  Boolean validationEnabled;
  public ExternalMetricSource build() {
    ExternalMetricSource buildable = new ExternalMetricSource(fluent.getMetric(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}