package io.fabric8.kubernetes.api.model.autoscaling.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ScaleStatusBuilder extends ScaleStatusFluentImpl<ScaleStatusBuilder> implements VisitableBuilder<ScaleStatus,ScaleStatusBuilder>{
  public ScaleStatusBuilder() {
    this(false);
  }
  public ScaleStatusBuilder(Boolean validationEnabled) {
    this(new ScaleStatus(), validationEnabled);
  }
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ScaleStatus(), validationEnabled);
  }
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent,ScaleStatus instance) {
    this(fluent, instance, false);
  }
  public ScaleStatusBuilder(ScaleStatusFluent<?> fluent,ScaleStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withReplicas(instance.getReplicas());
      fluent.withSelector(instance.getSelector());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ScaleStatusBuilder(ScaleStatus instance) {
    this(instance,false);
  }
  public ScaleStatusBuilder(ScaleStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withReplicas(instance.getReplicas());
      this.withSelector(instance.getSelector());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ScaleStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ScaleStatus build() {
    ScaleStatus buildable = new ScaleStatus(fluent.getReplicas(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}