package io.fabric8.kubernetes.api.model.autoscaling.v2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class HorizontalPodAutoscalerBuilder extends HorizontalPodAutoscalerFluentImpl<HorizontalPodAutoscalerBuilder> implements VisitableBuilder<HorizontalPodAutoscaler,HorizontalPodAutoscalerBuilder>{
  public HorizontalPodAutoscalerBuilder() {
    this(false);
  }
  public HorizontalPodAutoscalerBuilder(Boolean validationEnabled) {
    this(new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent) {
    this(fluent, false);
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new HorizontalPodAutoscaler(), validationEnabled);
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent,HorizontalPodAutoscaler instance) {
    this(fluent, instance, false);
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscalerFluent<?> fluent,HorizontalPodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscaler instance) {
    this(instance,false);
  }
  public HorizontalPodAutoscalerBuilder(HorizontalPodAutoscaler instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  HorizontalPodAutoscalerFluent<?> fluent;
  Boolean validationEnabled;
  public HorizontalPodAutoscaler build() {
    HorizontalPodAutoscaler buildable = new HorizontalPodAutoscaler(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}