package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ResourceMetricSourceBuilder extends ResourceMetricSourceFluentImpl<ResourceMetricSourceBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceBuilder>{
  public ResourceMetricSourceBuilder() {
    this(false);
  }
  public ResourceMetricSourceBuilder(Boolean validationEnabled) {
    this(new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(ResourceMetricSourceFluent<?> fluent) {
    this(fluent, false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ResourceMetricSource(), validationEnabled);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance) {
    this(fluent, instance, false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withTarget(instance.getTarget()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance) {
    this(instance,false);
  }
  public ResourceMetricSourceBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withTarget(instance.getTarget()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSourceFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ResourceMetricSource build() {
    ResourceMetricSource buildable = new ResourceMetricSource(fluent.getName(),fluent.getTarget());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}