package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ObjectMetricStatusBuilder extends ObjectMetricStatusFluentImpl<ObjectMetricStatusBuilder> implements VisitableBuilder<ObjectMetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusBuilder>{
  public ObjectMetricStatusBuilder() {
    this(false);
  }
  public ObjectMetricStatusBuilder(Boolean validationEnabled) {
    this(new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(ObjectMetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new ObjectMetricStatus(), validationEnabled);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance) {
    this(fluent, instance, false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withCurrent(instance.getCurrent()); 
    fluent.withDescribedObject(instance.getDescribedObject()); 
    fluent.withMetric(instance.getMetric()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance) {
    this(instance,false);
  }
  public ObjectMetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withCurrent(instance.getCurrent()); 
    this.withDescribedObject(instance.getDescribedObject()); 
    this.withMetric(instance.getMetric()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.ObjectMetricStatus build() {
    ObjectMetricStatus buildable = new ObjectMetricStatus(fluent.getCurrent(),fluent.getDescribedObject(),fluent.getMetric());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}