package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricValueStatusBuilder extends MetricValueStatusFluentImpl<MetricValueStatusBuilder> implements VisitableBuilder<MetricValueStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusBuilder>{
  public MetricValueStatusBuilder() {
    this(false);
  }
  public MetricValueStatusBuilder(Boolean validationEnabled) {
    this(new MetricValueStatus(), validationEnabled);
  }
  public MetricValueStatusBuilder(MetricValueStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MetricValueStatus(), validationEnabled);
  }
  public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance) {
    this(fluent, instance, false);
  }
  public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAverageUtilization(instance.getAverageUtilization()); 
    fluent.withAverageValue(instance.getAverageValue()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance) {
    this(instance,false);
  }
  public MetricValueStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAverageUtilization(instance.getAverageUtilization()); 
    this.withAverageValue(instance.getAverageValue()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricValueStatus build() {
    MetricValueStatus buildable = new MetricValueStatus(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}