package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricTargetBuilder extends MetricTargetFluentImpl<MetricTargetBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTargetBuilder>{
  public MetricTargetBuilder() {
    this(false);
  }
  public MetricTargetBuilder(Boolean validationEnabled) {
    this(new MetricTarget(), validationEnabled);
  }
  public MetricTargetBuilder(MetricTargetFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricTargetBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTargetFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MetricTarget(), validationEnabled);
  }
  public MetricTargetBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTargetFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget instance) {
    this(fluent, instance, false);
  }
  public MetricTargetBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTargetFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAverageUtilization(instance.getAverageUtilization()); 
    fluent.withAverageValue(instance.getAverageValue()); 
    fluent.withType(instance.getType()); 
    fluent.withValue(instance.getValue()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricTargetBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget instance) {
    this(instance,false);
  }
  public MetricTargetBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withAverageUtilization(instance.getAverageUtilization()); 
    this.withAverageValue(instance.getAverageValue()); 
    this.withType(instance.getType()); 
    this.withValue(instance.getValue()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTargetFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricTarget build() {
    MetricTarget buildable = new MetricTarget(fluent.getAverageUtilization(),fluent.getAverageValue(),fluent.getType(),fluent.getValue());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}