package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricStatusBuilder extends MetricStatusFluentImpl<MetricStatusBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusBuilder>{
  public MetricStatusBuilder() {
    this(false);
  }
  public MetricStatusBuilder(Boolean validationEnabled) {
    this(new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(MetricStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MetricStatus(), validationEnabled);
  }
  public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus instance) {
    this(fluent, instance, false);
  }
  public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withContainerResource(instance.getContainerResource()); 
    fluent.withExternal(instance.getExternal()); 
    fluent.withObject(instance.getObject()); 
    fluent.withPods(instance.getPods()); 
    fluent.withResource(instance.getResource()); 
    fluent.withType(instance.getType()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus instance) {
    this(instance,false);
  }
  public MetricStatusBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withContainerResource(instance.getContainerResource()); 
    this.withExternal(instance.getExternal()); 
    this.withObject(instance.getObject()); 
    this.withPods(instance.getPods()); 
    this.withResource(instance.getResource()); 
    this.withType(instance.getType()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatusFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricStatus build() {
    MetricStatus buildable = new MetricStatus(fluent.getContainerResource(),fluent.getExternal(),fluent.getObject(),fluent.getPods(),fluent.getResource(),fluent.getType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}