package io.fabric8.kubernetes.api.model.autoscaling.v2beta2;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MetricIdentifierBuilder extends MetricIdentifierFluentImpl<MetricIdentifierBuilder> implements VisitableBuilder<MetricIdentifier,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifierBuilder>{
  public MetricIdentifierBuilder() {
    this(false);
  }
  public MetricIdentifierBuilder(Boolean validationEnabled) {
    this(new MetricIdentifier(), validationEnabled);
  }
  public MetricIdentifierBuilder(MetricIdentifierFluent<?> fluent) {
    this(fluent, false);
  }
  public MetricIdentifierBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifierFluent<?> fluent,java.lang.Boolean validationEnabled) {
    this(fluent, new MetricIdentifier(), validationEnabled);
  }
  public MetricIdentifierBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifierFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifier instance) {
    this(fluent, instance, false);
  }
  public MetricIdentifierBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifierFluent<?> fluent,io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifier instance,java.lang.Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withName(instance.getName()); 
    fluent.withSelector(instance.getSelector()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public MetricIdentifierBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifier instance) {
    this(instance,false);
  }
  public MetricIdentifierBuilder(io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifier instance,java.lang.Boolean validationEnabled) {
    this.fluent = this; 
    this.withName(instance.getName()); 
    this.withSelector(instance.getSelector()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifierFluent<?> fluent;
  java.lang.Boolean validationEnabled;
  public io.fabric8.kubernetes.api.model.autoscaling.v2beta2.MetricIdentifier build() {
    MetricIdentifier buildable = new MetricIdentifier(fluent.getName(),fluent.getSelector());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}